/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.microservice.contract.Task;
import org.egov.infra.microservice.utils.MicroserviceUtils;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.support.ui.Inbox;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/inbox"})
public class InboxController {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy hh:mm a");
    private static final Logger LOG = Logger.getLogger(InboxController.class);
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private MicroserviceUtils microserviceUtils;

    @RequestMapping(produces={"text/plain"})
    @ResponseBody
    public String showInbox() {
        return this.createInboxData(this.inboxRenderServiceDeligate.getInboxItems(this.securityUtils.getCurrentUser().getId()));
    }

    @RequestMapping(value={"/draft"}, produces={"text/plain"})
    @ResponseBody
    public String showInboxDraft() {
        return this.createInboxData(this.inboxRenderServiceDeligate.getInboxDraftItems(this.securityUtils.getCurrentUser().getId()));
    }

    @RequestMapping(value={"/history"}, produces={"text/plain"})
    @ResponseBody
    public String showInboxHistory(@RequestParam Long stateId) {
        List stateHistories = this.inboxRenderServiceDeligate.getWorkflowHistory(stateId);
        if (stateHistories != null) {
            return this.createInboxHistoryData(stateHistories);
        }
        return null;
    }

    private String createInboxData(List<StateAware> inboxStates) {
        ArrayList<Inbox> inboxItems = new ArrayList<Inbox>();
        for (StateAware stateAware : inboxStates) {
            State state = stateAware.getCurrentState();
            WorkflowTypes workflowTypes = this.inboxRenderServiceDeligate.getWorkflowType(stateAware.getStateType());
            Inbox inboxItem = new Inbox();
            inboxItem.setId(workflowTypes.isGrouped() ? "" : state.getId() + "#" + workflowTypes.getId());
            inboxItem.setDate(DATE_FORMATTER.print((ReadableInstant)new DateTime((Object)state.getCreatedDate())));
            inboxItem.setSender(state.getSenderName());
            inboxItem.setTask(StringUtils.isBlank((CharSequence)state.getNatureOfTask()) ? workflowTypes.getDisplayName() : state.getNatureOfTask());
            String nextAction = this.inboxRenderServiceDeligate.getNextAction(state);
            inboxItem.setStatus(state.getValue() + (StringUtils.isBlank((CharSequence)nextAction) ? "" : " - " + nextAction));
            inboxItem.setDetails(StringUtils.isBlank((CharSequence)stateAware.getStateDetails()) ? "" : stateAware.getStateDetails());
            inboxItem.setLink(workflowTypes.getLink().replace(":ID", stateAware.myLinkId()));
            inboxItem.setCreatedDate(state.getCreatedDate());
            inboxItems.add(inboxItem);
        }
        List tasks = this.microserviceUtils.getTasks();
        for (Task t : tasks) {
            Inbox inboxItem = new Inbox();
            inboxItem.setId(t.getId());
            inboxItem.setCreatedDate(t.getCreatedDate());
            inboxItem.setDate(DATE_FORMATTER.print((ReadableInstant)new DateTime((Object)t.getCreatedDate())));
            inboxItem.setSender(t.getSenderName());
            inboxItem.setTask(t.getNatureOfTask());
            inboxItem.setStatus(t.getStatus());
            inboxItem.setDetails(t.getDetails());
            inboxItem.setLink(t.getUrl());
            inboxItem.setSender(t.getSenderName());
            inboxItems.add(inboxItem);
        }
        Collections.sort(inboxItems);
        for (Inbox b : inboxItems) {
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)(DATE_FORMATTER.print((ReadableInstant)new DateTime((Object)b.getCreatedDate())) + "  " + b.getId() + "-" + b.getLink()));
        }
        Collections.reverse(inboxItems);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"before reverse");
        }
        for (Inbox b : inboxItems) {
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)(DATE_FORMATTER.print((ReadableInstant)new DateTime((Object)b.getCreatedDate())) + "  " + b.getId() + "-" + b.getLink()));
        }
        return "{ \"data\":" + new GsonBuilder().create().toJson(inboxItems) + "}";
    }

    private String createInboxHistoryData(List<StateHistory> stateHistories) {
        LinkedList<Inbox> inboxHistoryItems = new LinkedList<Inbox>();
        for (StateHistory stateHistory : stateHistories) {
            WorkflowTypes workflowTypes = this.inboxRenderServiceDeligate.getWorkflowType(stateHistory.getState().getType());
            Inbox inboxHistoryItem = new Inbox();
            inboxHistoryItem.setId(stateHistory.getState().getId().toString());
            inboxHistoryItem.setDate(DATE_FORMATTER.print((ReadableInstant)new DateTime((Object)stateHistory.getLastModifiedDate())));
            inboxHistoryItem.setSender(stateHistory.getSenderName());
            inboxHistoryItem.setTask(StringUtils.isBlank((CharSequence)stateHistory.getNatureOfTask()) ? workflowTypes.getDisplayName() : stateHistory.getNatureOfTask());
            inboxHistoryItem.setStatus(stateHistory.getValue() + (StringUtils.isBlank((CharSequence)stateHistory.getNextAction()) ? "" : "-" + stateHistory.getNextAction()));
            inboxHistoryItem.setDetails(StringUtils.isBlank((CharSequence)stateHistory.getComments()) ? "" : org.egov.infra.utils.StringUtils.escapeSpecialChars((String)stateHistory.getComments()));
            inboxHistoryItem.setLink("");
            inboxHistoryItems.add(inboxHistoryItem);
        }
        return "{ \"data\":" + new GsonBuilder().disableHtmlEscaping().create().toJson(inboxHistoryItems) + "}";
    }
}

