/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.hierarchytype;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hierarchytype"})
public class CreateHierarchyTypeController {
    private static final String REDIRECT_URL_VIEW = "redirect:/hierarchytype/view/";
    private static final String REQUEST_MAP_CREATE = "/create";
    private HierarchyTypeService hierarchyTypeService;

    @Autowired
    public CreateHierarchyTypeController(HierarchyTypeService hierarchyTypeService) {
        this.hierarchyTypeService = hierarchyTypeService;
    }

    @ModelAttribute
    public HierarchyType hierarchyTypeModel() {
        return new HierarchyType();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String hierarchyTypeForm(Model model) {
        return "hierarchyType-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createHierarchyType(@ModelAttribute @Valid HierarchyType hierarchyType, BindingResult errors, RedirectAttributes additionalAttr) {
        if (errors.hasErrors()) {
            return "hierarchyType-form";
        }
        this.hierarchyTypeService.createHierarchyType(hierarchyType);
        additionalAttr.addFlashAttribute("message", (Object)"msg.success.hierarchytype.create");
        return REDIRECT_URL_VIEW + hierarchyType.getName();
    }
}

