/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.config;

import java.util.List;
import org.egov.infra.admin.master.contracts.AppConfigSearchRequest;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.web.response.adapter.AppConfigJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/config"})
public class ViewAppConfigController {
    @Autowired
    private AppConfigService appConfigService;
    @Autowired
    private ModuleService moduleService;

    @GetMapping(value={"/formodule/{moduleName}"}, produces={"application/json"})
    @ResponseBody
    public List<AppConfig> getAppConfigsForModule(@PathVariable String moduleName) {
        return this.appConfigService.getAllAppConfigByModuleName(moduleName);
    }

    @GetMapping(value={"/view"})
    public String viewAppConfig(Model model) {
        model.addAttribute("modules", (Object)this.moduleService.getAllTopModules());
        return "app-config-view";
    }

    @GetMapping(value={"/list"}, produces={"text/plain"})
    @ResponseBody
    public String showAppConfigs(AppConfigSearchRequest searchRequest) {
        return new DataTable(this.appConfigService.getAllAppConfig(searchRequest), (long)searchRequest.draw()).toJson(AppConfigJsonAdapter.class);
    }
}

