/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.config;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.service.AppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/app/config/update/{moduleName}/{keyName}"})
public class UpdateAppConfigController {
    private final AppConfigService appConfigService;

    @Autowired
    public UpdateAppConfigController(AppConfigService appConfigValueService) {
        this.appConfigService = appConfigValueService;
    }

    @ModelAttribute
    public AppConfig appConfig(@PathVariable String moduleName, @PathVariable String keyName) {
        return this.appConfigService.getAppConfigByModuleNameAndKeyName(moduleName, keyName);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String updateAppConfigForm(@ModelAttribute AppConfig appConfig, RedirectAttributes redirectAttrs) {
        if (appConfig == null) {
            redirectAttrs.addFlashAttribute("message", (Object)"err.app.config.not.found");
            return "redirect:/app/config/update";
        }
        return "app-config-edit";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateAppConfig(@Valid @ModelAttribute AppConfig appConfig, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "app-config-edit";
        }
        this.appConfigService.updateAppConfig(appConfig);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.appconfig.update.success");
        return "redirect:/app/config/update/" + appConfig.getModule().getName() + "/" + appConfig.getKeyName();
    }
}

