/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.feature;

import java.util.List;
import org.egov.infra.admin.master.entity.Feature;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.FeatureAccessControlService;
import org.egov.infra.admin.master.service.FeatureService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/feature/access-control"})
public class FeatureAccessControlController {
    @Autowired
    private FeatureService featureService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private FeatureAccessControlService featureAccessControlService;

    @RequestMapping(value={"/by-feature"}, method={RequestMethod.GET})
    public String createByFeature(Model model) {
        model.addAttribute("features", (Object)this.featureService.getAllFeatures());
        model.addAttribute("modules", (Object)this.moduleService.getAllTopModules());
        return "accesscontrol-search";
    }

    @RequestMapping(value={"/by-role"}, method={RequestMethod.GET})
    public String createByRole(Model model) {
        model.addAttribute("roles", (Object)this.roleService.getAllRoles());
        model.addAttribute("modules", (Object)this.moduleService.getAllTopModules());
        return "accesscontrol-search";
    }

    @RequestMapping(value={"/by-feature"}, method={RequestMethod.POST})
    public String createByFeature(@RequestParam Long featureId, Model model) {
        model.addAttribute("roles", (Object)this.roleService.getAllRoles());
        model.addAttribute("feature", (Object)this.featureService.getFeatureById(featureId));
        return "accesscontrol";
    }

    @RequestMapping(value={"/by-role"}, method={RequestMethod.POST})
    public String createByRole(@RequestParam Long roleId, @RequestParam(required=false) Long moduleId, Model model) {
        model.addAttribute("features", (Object)(moduleId == null ? this.featureService.getAllFeatures() : this.featureService.getAllFeaturesByModuleId(moduleId)));
        model.addAttribute("role", (Object)this.roleService.getRoleById(roleId));
        return "accesscontrol";
    }

    @RequestMapping(value={"/grant/{featureId}/{roleId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String createFeatureRoleMapping(@PathVariable(value="featureId") Feature feature, @PathVariable(value="roleId") Role role) {
        this.featureAccessControlService.grantAccess(feature, role);
        return "DONE";
    }

    @RequestMapping(value={"/revoke/{featureId}/{roleId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String removeFeatureRoleMapping(@PathVariable(value="featureId") Feature feature, @PathVariable(value="roleId") Role role) {
        this.featureAccessControlService.revokeAccess(feature, role);
        return "DONE";
    }

    @RequestMapping(value={"/list-by-module/{moduleId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Feature> featuresByModule(@PathVariable Long moduleId) {
        return this.featureService.getAllFeaturesByModuleId(moduleId);
    }
}

