/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.config.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.utils.DateUtils;

public class AppConfigJsonAdaptor
implements JsonSerializer<AppConfig> {
    public JsonElement serialize(AppConfig appConfig, Type type, JsonSerializationContext jsc) {
        JsonObject appConfigJSON = new JsonObject();
        appConfigJSON.addProperty("keyName", appConfig.getKeyName());
        appConfigJSON.addProperty("description", appConfig.getDescription());
        appConfigJSON.addProperty("module", appConfig.getModule().getName());
        appConfigJSON.addProperty("id", (Number)appConfig.getId());
        JsonArray configValues = new JsonArray();
        for (AppConfigValues confValue : appConfig.getConfValues()) {
            JsonObject configValueJSON = new JsonObject();
            configValueJSON.addProperty("Effective Date", DateUtils.getDefaultFormattedDate((Date)confValue.getEffectiveFrom()));
            configValueJSON.addProperty("Value", confValue.getValue());
            configValues.add((JsonElement)configValueJSON);
        }
        appConfigJSON.add("values", (JsonElement)configValues);
        return appConfigJSON;
    }
}

