/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.config;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.ModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/app/config/create"})
public class CreateAppConfigController {
    private final AppConfigService appConfigValueService;
    @Autowired
    private ModuleService moduleService;

    @Autowired
    public CreateAppConfigController(AppConfigService appConfigValueService) {
        this.appConfigValueService = appConfigValueService;
    }

    @ModelAttribute
    public AppConfig appConfig() {
        return new AppConfig();
    }

    @ModelAttribute(value="modules")
    public List<Module> modules() {
        return this.moduleService.getAllTopModules();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String createAppConfigForm() {
        return "app-config-create";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String createAppConfig(@Valid @ModelAttribute AppConfig appConfig, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "app-config-create";
        }
        this.appConfigValueService.createAppConfig(appConfig);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.appconfig.create.success");
        return "redirect:/app/config/update/" + appConfig.getModule().getName() + "/" + appConfig.getKeyName();
    }
}

