/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.FileStoreUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/downloadfile"})
public class FileDownloadController {
    public static final String LOGO_IMAGE_PATH = "/resources/global/images/";
    public static final String CITY_LOGO_KEY = "citylogo";
    @Autowired
    private FileStoreUtils fileStoreUtils;

    @RequestMapping
    public void download(@RequestParam String fileStoreId, @RequestParam String moduleName, @RequestParam(defaultValue="false") boolean toSave, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, moduleName, toSave, response);
    }

    @RequestMapping(value={"/logo"})
    public String download(@RequestParam String fileStoreId, @RequestParam String moduleName, HttpSession session) throws IOException, ServletException {
        String cityLogoKey;
        String logoPath = LOGO_IMAGE_PATH + fileStoreId + ".jpg";
        Path logoRealPath = Paths.get(session.getServletContext().getRealPath(LOGO_IMAGE_PATH) + File.separator + fileStoreId + ".jpg", new String[0]);
        if (!Files.exists(logoRealPath, new LinkOption[0]) && (cityLogoKey = (String)session.getAttribute(CITY_LOGO_KEY)) != null && cityLogoKey.contains(fileStoreId)) {
            this.fileStoreUtils.copyFileToPath(logoRealPath, fileStoreId, moduleName);
        }
        return "forward:" + logoPath;
    }

    @RequestMapping(value={"/gis"})
    public void download(HttpServletResponse response) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("gis/" + ApplicationThreadLocals.getTenantID() + "/wards.kml");
             ServletOutputStream out = response.getOutputStream();){
            if (in != null) {
                response.setHeader("Content-Disposition", "inline;filename=wards.kml");
                response.setContentType("application/vnd.google-earth.kml+xml");
                IOUtils.write((byte[])IOUtils.toByteArray((InputStream)in), (OutputStream)out);
            }
        }
    }
}

