/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.user;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/user"})
public class ResetPasswordController {
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @ModelAttribute(value="users")
    public List<User> users() {
        return this.userService.getAllEmployeeUsers();
    }

    @RequestMapping(value={"/reset-password"})
    public String showResetPassword() {
        return "reset-password";
    }

    @RequestMapping(value={"/reset-password"}, method={RequestMethod.POST})
    public String resetPassword(@RequestParam String username, @RequestParam String password, RedirectAttributes redirAttrib) {
        User user = this.userService.getUserByUsername(username);
        user.setPassword(this.passwordEncoder.encode((CharSequence)password));
        this.userService.updateUser(user);
        redirAttrib.addFlashAttribute("message", (Object)"lbl.pwd.reset.success");
        redirAttrib.addFlashAttribute("name", (Object)user.getName());
        return "redirect:/user/reset-password";
    }
}

