/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.hierarchytype;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hierarchytype"})
public class UpdateHierarchyTypeController {
    private static final String REDIRECT_URL_VIEW = "redirect:/hierarchytype/view/";
    private static final String REQUEST_MAP_UPDATE = "/update/{name}";
    private HierarchyTypeService hierarchyTypeService;

    @Autowired
    public UpdateHierarchyTypeController(HierarchyTypeService hierarchyTypeService) {
        this.hierarchyTypeService = hierarchyTypeService;
    }

    @ModelAttribute
    public HierarchyType hierarchyTypeModel(@PathVariable String name) {
        return this.hierarchyTypeService.getHierarchyTypeByName(name);
    }

    @RequestMapping(value={"/update/{name}"}, method={RequestMethod.GET})
    public String hierarchyTypeUpdateForm(Model model) {
        return "hierarchyType-updateForm";
    }

    @RequestMapping(value={"/update/{name}"}, method={RequestMethod.POST})
    public String updateHierarchyType(@ModelAttribute @Valid HierarchyType hierarchyType, BindingResult errors, RedirectAttributes additionalAttr) {
        if (errors.hasErrors()) {
            return "hierarchyType-updateForm";
        }
        HierarchyType updatedHierarchyType = this.hierarchyTypeService.updateHierarchyType(hierarchyType);
        additionalAttr.addFlashAttribute("hierarchyType", (Object)updatedHierarchyType);
        additionalAttr.addFlashAttribute("message", (Object)"msg.success.hierarchytype.update");
        return REDIRECT_URL_VIEW + hierarchyType.getName();
    }
}

