/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.hierarchytype;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hierarchytype"})
public class SearchHierarchyTypeController {
    private static final String REQUEST_MAP_VIEW = "/view";
    private static final String REQUEST_MAP_UPDATE = "/update";
    private final HierarchyTypeService hierarchyTypeService;

    @Autowired
    public SearchHierarchyTypeController(HierarchyTypeService hierarchyTypeService) {
        this.hierarchyTypeService = hierarchyTypeService;
    }

    @ModelAttribute
    public HierarchyType hierarchyTypeModel() {
        return new HierarchyType();
    }

    @ModelAttribute(value="hierarchyTypes")
    public List<HierarchyType> listHierarchyTypes() {
        return this.hierarchyTypeService.getAllHierarchyTypes();
    }

    @RequestMapping(value={"/view", "/update"}, method={RequestMethod.GET})
    public String showHierarchyTypes(Model model) {
        return "hierarchyType-list";
    }

    @RequestMapping(value={"/view", "/update"}, method={RequestMethod.POST})
    public String search(@ModelAttribute HierarchyType hierarchyType, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "boundaryType-form";
        }
        String requestURI = request.getRequestURI();
        String redirectURI = "";
        if (requestURI.contains("view")) {
            redirectURI = "redirect:/hierarchytype/view/" + hierarchyType.getName();
        } else if (requestURI.contains("update")) {
            redirectURI = "redirect:/hierarchytype/update/" + hierarchyType.getName();
        }
        return redirectURI;
    }
}

