/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundarytype;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/boundarytype/create"})
public class CreateBoundaryTypeController {
    private HierarchyTypeService hierarchyTypeService;
    private BoundaryTypeService boundaryTypeService;

    @Autowired
    public CreateBoundaryTypeController(BoundaryTypeService boundaryTypeService, HierarchyTypeService hierarchyTypeService) {
        this.boundaryTypeService = boundaryTypeService;
        this.hierarchyTypeService = hierarchyTypeService;
    }

    @ModelAttribute
    public BoundaryType boundaryTypeModel() {
        return new BoundaryType();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm() {
        return "boundaryType-form";
    }

    @ModelAttribute(value="hierarchyTypes")
    public List<HierarchyType> getHierarchyTypes() {
        ArrayList<HierarchyType> heirarchyList = new ArrayList<HierarchyType>();
        List hierarchyTypeList = this.hierarchyTypeService.getAllHierarchyTypes();
        for (HierarchyType hierarchyType : hierarchyTypeList) {
            BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByHierarchyTypeNameAndLevel(hierarchyType.getName(), Long.valueOf(1L));
            if (bType != null) continue;
            heirarchyList.add(hierarchyType);
        }
        return heirarchyList;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute BoundaryType boundaryType, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "boundaryType-form";
        }
        this.boundaryTypeService.setHierarchyLevel(boundaryType, "create");
        this.boundaryTypeService.createBoundaryType(boundaryType);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bndrytype.create.success");
        return "redirect:/boundarytype/view/" + boundaryType.getId();
    }
}

