/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundarytype;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/boundarytype/addchild/{id}"})
public class AddChildBoundaryTypeController {
    private BoundaryTypeService boundaryTypeService;

    @Autowired
    public AddChildBoundaryTypeController(BoundaryTypeService boundaryTypeService) {
        this.boundaryTypeService = boundaryTypeService;
    }

    @ModelAttribute
    public BoundaryType boundaryTypeModel(@PathVariable Long id) {
        BoundaryType child = new BoundaryType();
        BoundaryType parent = this.boundaryTypeService.getBoundaryTypeById(id);
        child.setHierarchyType(parent.getHierarchyType());
        child.setParent(parent);
        return child;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String addChildForm() {
        return "boundaryType-addChild";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String addChildBoundaryType(@Valid @ModelAttribute BoundaryType boundaryType, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "boundaryType-addChild";
        }
        Long parentBoundaryTypeId = boundaryType.getParent().getId();
        BoundaryType boundaryType1 = this.boundaryTypeService.getBoundaryTypeByParent(parentBoundaryTypeId);
        if (boundaryType1 != null) {
            redirectAttrs.addFlashAttribute("errorMessage", (Object)"err.child.bndrytype.exist");
            return "redirect:/boundarytype/addchild/" + parentBoundaryTypeId;
        }
        if (boundaryType.getParent().getName().equalsIgnoreCase(boundaryType.getName())) {
            redirectAttrs.addFlashAttribute("errorMessage", (Object)"err.child.parent.same.name");
            return "redirect:/boundarytype/addchild/" + parentBoundaryTypeId;
        }
        this.boundaryTypeService.setHierarchyLevel(boundaryType, "addChild");
        this.boundaryTypeService.createBoundaryType(boundaryType);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.child.bndrytype.create.success");
        return "redirect:/boundarytype/view/" + boundaryType.getId();
    }
}

