/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.support.json.adapter.BoundaryAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PageViewBoundaryController {
    private final BoundaryService boundaryService;

    @Autowired
    public PageViewBoundaryController(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    @RequestMapping(value={"/list-boundaries"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long boundaryTypeId = Long.valueOf(request.getParameter("boundaryTypeId"));
        List pageOfBoundaries = this.boundaryService.getPageOfBoundaries(boundaryTypeId);
        StringBuilder boundaryJSONData = new StringBuilder("{\"data\":").append(this.toJSON((Object)pageOfBoundaries)).append("}");
        response.setContentType("application/json");
        IOUtils.write((CharSequence)boundaryJSONData, (Writer)response.getWriter());
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Boundary.class, (Object)new BoundaryAdapter()).create();
        String json = gson.toJson(object);
        return json;
    }
}

