/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class CreateBoundaryController {
    private static final String REDIRECT_URL_VIEW = "redirect:/view-boundary/";
    private final BoundaryService boundaryService;
    private final BoundaryTypeService boundaryTypeService;

    @Autowired
    public CreateBoundaryController(BoundaryService boundaryService, BoundaryTypeService boundaryTypeService) {
        this.boundaryService = boundaryService;
        this.boundaryTypeService = boundaryTypeService;
    }

    @RequestMapping(value={"/boundary/create"}, method={RequestMethod.POST})
    public String createOrUpdateBoundary(@Valid @ModelAttribute Boundary boundary, BindingResult errors, RedirectAttributes redirectAttributes, Model model) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(boundary.getBoundaryTypeId());
        model.addAttribute("boundaryType", (Object)boundaryType);
        if (errors.hasErrors()) {
            return "boundary-create";
        }
        boundary.setBoundaryType(boundaryType);
        boundary.setHistory(false);
        boundary.setMaterializedPath(this.boundaryService.getMaterializedPath(null, boundary.getParent()));
        this.boundaryService.createBoundary(boundary);
        redirectAttributes.addFlashAttribute("boundary", (Object)boundary);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.bndry.create.success");
        String pathVars = boundaryType.getHierarchyType().getId() + "," + boundaryType.getId();
        return REDIRECT_URL_VIEW + pathVars;
    }

    @RequestMapping(value={"/wards-by-zone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getWardByZone(@RequestParam Long zoneId) throws IOException {
        return this.boundaryService.getActiveChildBoundariesByBoundaryId(zoneId);
    }
}

