/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.appConfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigAdaptor;
import org.egov.infra.admin.master.service.AppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

@Controller
@RequestMapping(value={"/appConfig"})
public class ViewAppConfigController
extends MultiActionController {
    private AppConfigService appConfigService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @Autowired
    public ViewAppConfigController(AppConfigService appConfigService) {
        this.appConfigService = appConfigService;
    }

    @RequestMapping(value={"view"}, method={RequestMethod.GET})
    public String AppConfigViewForm(@ModelAttribute AppConfig appConfig, Model model) {
        return "view-appconfig";
    }

    @RequestMapping(value={"/viewList/{id}"}, method={RequestMethod.GET})
    public String viewAppConfigForm(Model model, @ModelAttribute AppConfig appConfig, @PathVariable Long id) {
        appConfig = this.appConfigService.findById(id);
        model.addAttribute("appConfig", (Object)appConfig);
        return "appConfigList-view";
    }

    public String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AppConfig.class, (Object)new AppConfigAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"ajax/result"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int pageStart = Integer.valueOf(request.getParameter("start"));
        int pageSize = Integer.valueOf(request.getParameter("length"));
        int pageNumber = pageStart / pageSize + 1;
        List totalRecords = this.appConfigService.findAll();
        if (pageSize == -1) {
            pageSize = totalRecords.size();
        }
        List complaintTypeList = this.appConfigService.getListOfAppConfig(Integer.valueOf(pageNumber), Integer.valueOf(pageSize)).getContent();
        StringBuilder appConfigJSONData = new StringBuilder();
        appConfigJSONData.append("{\"draw\": ").append("0");
        appConfigJSONData.append(",\"recordsTotal\":").append(totalRecords.size());
        appConfigJSONData.append(",\"totalDisplayRecords\":").append(complaintTypeList.size());
        appConfigJSONData.append(",\"recordsFiltered\":").append(totalRecords.size());
        appConfigJSONData.append(",\"data\":").append(this.toJSON((Object)complaintTypeList)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)appConfigJSONData, (Writer)response.getWriter());
    }
}

