/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.appConfig;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/appConfig/update"})
public class SearchAppConfigController {
    private AppConfigService appConfigValueService;

    @Autowired
    public SearchAppConfigController(AppConfigService appConfigValueService) {
        this.appConfigValueService = appConfigValueService;
    }

    @ModelAttribute
    public AppConfig appConfigModel() {
        return new AppConfig();
    }

    @ModelAttribute(value="appConfigList")
    public List<AppConfig> listAppConfig() {
        return this.appConfigValueService.findAll();
    }

    @ModelAttribute(value="modulesList")
    public List<Module> findAllModules() {
        return this.appConfigValueService.findAllModules();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showAppConfigValues(Model model) {
        return "appConfig-list";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String search(@ModelAttribute AppConfig appConfig, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "appConfig-list";
        }
        return "redirect:/appConfig/update/" + appConfig.getKeyName() + "," + appConfig.getModule().getName();
    }
}

