/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.appConfig;

import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/appConfig/update/{keyNameArray}"})
public class ModifyAppConfigController {
    private final AppConfigService appConfigValueService;
    private final AppConfigValueService appConfig111Service;

    @Autowired
    public ModifyAppConfigController(AppConfigService appConfigValueService, AppConfigValueService appConfigService, ModuleService moduleService) {
        this.appConfig111Service = appConfigService;
        this.appConfigValueService = appConfigValueService;
    }

    @ModelAttribute
    public AppConfig appConfigModel(@PathVariable String[] keyNameArray, Model model) {
        Long keyName = null;
        Long moduleName = null;
        if (keyNameArray.length > 1) {
            keyName = Long.parseLong(keyNameArray[0]);
            moduleName = Long.parseLong(keyNameArray[1]);
        }
        return this.appConfigValueService.findBykeyNameAndModuleName(keyName, moduleName);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String appConfigFormForUpdate(@ModelAttribute AppConfig appConfig, Model model) {
        if (appConfig != null) {
            if (appConfig.getAppDataValues().isEmpty()) {
                appConfig.addAppDataValues(new AppConfigValues());
            } else {
                appConfig.setAppDataValues(appConfig.getAppDataValues());
            }
            this.appConfig111Service.getConfigValuesByModuleAndKey(appConfig.getModule().getName(), appConfig.getKeyName());
            this.appConfigValueService.getAppConfigKeys(appConfig.getModule().getName());
            model.addAttribute("mode", (Object)"update");
            return "appConfig-editform";
        }
        model.addAttribute("message", (Object)"msg.no.record.found");
        return "appConfig-norecord";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateAppconfig(@Valid @ModelAttribute AppConfig appConfig, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "appConfig-editform";
        }
        appConfig = this.buildAppConfigValueDeatils(appConfig, appConfig.getAppDataValues());
        this.appConfigValueService.updateAppConfigValues(appConfig);
        redirectAttrs.addFlashAttribute("appConfig", (Object)appConfig);
        model.addAttribute("message", (Object)"msg.appconfig.update.success");
        return "appConfig-success";
    }

    private AppConfig buildAppConfigValueDeatils(AppConfig appConfig, List<AppConfigValues> unitDetail) {
        HashSet<AppConfigValues> unitSet = new HashSet<AppConfigValues>();
        for (AppConfigValues unitdetail : unitDetail) {
            if (unitdetail.getEffectiveFrom() == null || "".equals(unitdetail.getValue())) continue;
            unitdetail.setKey(appConfig);
            unitSet.add(unitdetail);
        }
        appConfig.getAppDataValues().clear();
        appConfig.getAppDataValues().addAll(unitSet);
        return appConfig;
    }
}

