/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.appConfig;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Repository
@RequestMapping(value={"/appConfig"})
public class GenericAppConfigAjaxController {
    private final AppConfigService appConfigValueService;

    @Autowired
    public GenericAppConfigAjaxController(AppConfigService appConfigValueService) {
        this.appConfigValueService = appConfigValueService;
    }

    @RequestMapping(value={"/modules"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Module> getAllModulesByNameLike(@RequestParam String moduleName, HttpServletResponse response) throws IOException {
        String likemoduleName = "%" + moduleName + "%";
        return this.appConfigValueService.findByNameContainingIgnoreCase(likemoduleName);
    }

    @RequestMapping(value={"/ajax-appConfigpopulate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AppConfig> getAppConfigs(@ModelAttribute(value="appConfig") @RequestParam Long appModuleName) {
        List appConfig = this.appConfigValueService.findAllByModule(appModuleName);
        appConfig.forEach(appConfigs -> appConfigs.toString());
        return appConfig;
    }
}

