/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.appConfig;

import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/appConfig/create"})
public class CreateAppConfigController {
    private final AppConfigService appConfigValueService;

    @Autowired
    public CreateAppConfigController(AppConfigService appConfigValueService) {
        this.appConfigValueService = appConfigValueService;
    }

    @ModelAttribute
    public AppConfig appConfig() {
        return new AppConfig();
    }

    @ModelAttribute(value="modulesList")
    public List<Module> findAllModules() {
        return this.appConfigValueService.findAllModules();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String createAppConfigValueForm(@ModelAttribute AppConfig appConfig, Model model) {
        if (appConfig.getAppDataValues().isEmpty()) {
            appConfig.addAppDataValues(new AppConfigValues());
        }
        model.addAttribute("mode", (Object)"new");
        return "appConfig-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String createAppConfigValue(@Valid @ModelAttribute AppConfig appConfig, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "appConfig-form";
        }
        appConfig = this.buildappConfigDetails(appConfig, appConfig.getAppDataValues());
        this.appConfigValueService.createAppConfigValues(appConfig);
        model.addAttribute("mode", (Object)"new");
        redirectAttrs.addFlashAttribute("appConfig", (Object)appConfig);
        model.addAttribute("message", (Object)"msg.appconfig.create.success");
        return "appConfig-success";
    }

    private AppConfig buildappConfigDetails(AppConfig appConfig, List<AppConfigValues> unitDetail) {
        HashSet<AppConfigValues> unitSet = new HashSet<AppConfigValues>();
        for (AppConfigValues unitdetail : unitDetail) {
            if (unitdetail.getEffectiveFrom() == null || "".equals(unitdetail.getValue())) continue;
            unitdetail.setKey(appConfig);
            unitSet.add(unitdetail);
        }
        appConfig.getAppDataValues().clear();
        appConfig.getAppDataValues().addAll(unitSet);
        return appConfig;
    }
}

