/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.crosshierarchy;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/crosshierarchy/update"})
public class SearchCrossHierarchyController {
    private static final String ADMIN_HIERARCHY_TYPE = "ADMIN";
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    @ModelAttribute
    public CrossHierarchy crossHierarchyModel() {
        return new CrossHierarchy();
    }

    @ModelAttribute(value="boundaryTypeList")
    public List<BoundaryType> findAllBoundaryType() {
        HashSet<String> hierarchyNames = new HashSet<String>();
        hierarchyNames.add(ADMIN_HIERARCHY_TYPE);
        List boundaryType = this.boundaryTypeService.getBoundaryTypeByHierarchyTypeNames(hierarchyNames);
        return boundaryType;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showCrossHierarchyValues(Model model) {
        return "crossHierarchy-list";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String search(@ModelAttribute CrossHierarchy crossHierarchy, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "crossHierarchy-list";
        }
        return "redirect:/crosshierarchy/update/" + crossHierarchy.getParent().getName() + "," + crossHierarchy.getParentType().getName();
    }
}

