/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.department;

import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/department/"})
public class SearchDepartmentController {
    private static final String UPDATE = "update";
    private static final String VIEW = "view";
    private final DepartmentService departmentService;

    @Autowired
    public SearchDepartmentController(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @ModelAttribute
    public Department departmentModel() {
        return new Department();
    }

    @RequestMapping(value={"view", "update"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        return "department-search";
    }

    @RequestMapping(value={"view"}, method={RequestMethod.POST})
    public String viewDepartment(@ModelAttribute Department department) {
        return "redirect:/department/view/" + department.getName();
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public String updateDepartmentForm(@ModelAttribute Department department) {
        return "redirect:/department/update/" + department.getName();
    }
}

