/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GenericMasterAjaxController {
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    private static final String BLOCK = "Block";
    private static final String REVENUE_HIERARCHY_TYPE = "REVENUE";

    @RequestMapping(value={"/boundarytype/ajax/boundarytypelist-for-hierarchy"}, method={RequestMethod.GET})
    @ResponseBody
    public void getBoundaryTypeByHierarchyType(@RequestParam Long hierarchyTypeId, HttpServletResponse response) throws IOException {
        List boundaryTypes = this.boundaryTypeService.getAllBoundarTypesByHierarchyTypeId(hierarchyTypeId);
        response.setContentType("application/json");
        IOUtils.write((String)this.buildJSONString(boundaryTypes), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/boundaries-by-boundaryType"}, method={RequestMethod.GET})
    @ResponseBody
    public void getBoundariesByBoundaryType(@RequestParam Long boundaryTypeId, HttpServletResponse response) throws IOException {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(boundaryTypeId);
        List boundaries = this.boundaryService.getAllBoundariesOrderByBoundaryNumAsc(boundaryType);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (Boundary boundary : boundaries) {
            jsonObject = new JSONObject();
            jsonObject.put((Object)"Text", (Object)boundary.getLocalName());
            jsonObject.put((Object)"Value", (Object)boundary.getId());
            jsonArray.add((Object)jsonObject);
        }
        response.setContentType("application/json");
        IOUtils.write((String)jsonArray.toString(), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/check-is-root"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isRootBoundary(@RequestParam Long boundaryTypeId, @RequestParam Long hierarchyTypeId) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByIdAndHierarchyType(boundaryTypeId, hierarchyTypeId);
        return boundaryType.getParent() == null ? false : boundaryType.getParent().getId() == 0L;
    }

    private String buildJSONString(List<BoundaryType> boundaryTypes) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (BoundaryType boundaryType : boundaryTypes) {
            jsonObject = new JSONObject();
            jsonObject.put((Object)"Text", (Object)boundaryType.getName());
            jsonObject.put((Object)"Value", (Object)boundaryType.getId());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/boundarytype/ajax/checkchild"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isChildBoundaryTypePresent(@RequestParam Long parentId) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByParent(parentId);
        return boundaryType != null ? Boolean.TRUE : Boolean.FALSE;
    }

    @RequestMapping(value={"/userRole/ajax/rolelist-for-user"}, method={RequestMethod.GET})
    @ResponseBody
    public void getRolesByUserName(@RequestParam String username, HttpServletResponse response) throws IOException {
        if (username != null) {
            Set roles = this.userService.getRolesByUsername(username);
            response.setContentType("application/json");
            IOUtils.write((String)this.buildRoles(roles), (Writer)response.getWriter());
        }
    }

    private String buildRoles(Set<Role> roles) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (Role role : roles) {
            jsonObject = new JSONObject();
            jsonObject.put((Object)"Value", (Object)role.getId());
            jsonObject.put((Object)"Text", (Object)role.getName());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/userRole/ajax/userlist"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void getAllActiveUserByNameLike(@RequestParam String userName, HttpServletResponse response) throws IOException {
        List userList = this.userService.findAllByMatchingUserNameForType(userName, UserType.EMPLOYEE);
        response.setContentType("application/json");
        IOUtils.write((String)this.buildUser(userList), (Writer)response.getWriter());
    }

    private String buildUser(List<User> users) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        for (User user : users) {
            jsonObject = new JSONObject();
            jsonObject.put((Object)"Value", (Object)user.getId());
            jsonObject.put((Object)"Text", (Object)user.getUsername());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/boundary/ajaxBoundary-blockByLocality", "/public/boundary/ajaxBoundary-blockByLocality"}, method={RequestMethod.GET})
    public void blockByLocality(@RequestParam Long locality, HttpServletResponse response) throws IOException {
        BoundaryType blockType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(BLOCK, REVENUE_HIERARCHY_TYPE);
        List blocks = this.crossHierarchyService.getParentBoundaryByChildBoundaryAndParentBoundaryType(locality, blockType.getId());
        List streets = this.boundaryService.getChildBoundariesByBoundaryId(locality);
        ArrayList<JSONObject> wardJsonObjs = new ArrayList<JSONObject>();
        ArrayList<Long> boundaries = new ArrayList<Long>();
        for (Object block : blocks) {
            Boundary ward = block.getParent();
            JSONObject jsonObject = new JSONObject();
            if (!boundaries.contains(ward.getId())) {
                jsonObject.put((Object)"wardId", (Object)ward.getId());
                jsonObject.put((Object)"wardName", (Object)ward.getName());
            }
            jsonObject.put((Object)"blockId", (Object)block.getId());
            jsonObject.put((Object)"blockName", (Object)block.getName());
            wardJsonObjs.add(jsonObject);
            boundaries.add(ward.getId());
        }
        ArrayList<JSONObject> streetJsonObjs = new ArrayList<JSONObject>();
        for (Boundary street : streets) {
            JSONObject streetObj = new JSONObject();
            streetObj.put((Object)"streetId", (Object)street.getId());
            streetObj.put((Object)"streetName", (Object)street.getName());
            streetJsonObjs.add(streetObj);
        }
        HashMap<String, ArrayList<JSONObject>> map = new HashMap<String, ArrayList<JSONObject>>();
        map.put("boundaries", wardJsonObjs);
        map.put("streets", streetJsonObjs);
        JSONObject bj = new JSONObject();
        bj.put((Object)"results", map);
        response.setContentType("application/json");
        IOUtils.write((String)bj.toString(), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/boundary/ajaxBoundary-blockByWard"}, method={RequestMethod.GET})
    public void blockByWard(@RequestParam Long wardId, HttpServletResponse response) throws IOException {
        List blocks = new ArrayList();
        blocks = this.boundaryService.getActiveChildBoundariesByBoundaryId(wardId);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (Boundary block : blocks) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"blockId", (Object)block.getId());
            jsonObj.put((Object)"blockName", (Object)block.getName());
            jsonObjects.add(jsonObj);
        }
        IOUtils.write((String)((Object)jsonObjects).toString(), (Writer)response.getWriter());
    }
}

