/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.config;

import java.util.Collection;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.web.controller.admin.masters.config.adaptor.AppConfigJsonAdaptor;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/config"})
public class ViewAppConfigController {
    private AppConfigService appConfigService;
    @Autowired
    private ModuleService moduleService;

    @Autowired
    public ViewAppConfigController(AppConfigService appConfigService) {
        this.appConfigService = appConfigService;
    }

    @RequestMapping(value={"/formodule/{moduleName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AppConfig> getAppConfigsForModule(@PathVariable String moduleName) {
        return this.appConfigService.getAllAppConfigByModuleName(moduleName);
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewAppConfig(Model model) {
        model.addAttribute("modules", (Object)this.moduleService.getAllTopModules());
        return "app-config-view";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String showAppConfigs(@RequestParam(required=false) String moduleName, @RequestParam Integer start, @RequestParam Integer length) {
        int pageNumber = start / length + 1;
        Page pagedAppConfigs = this.appConfigService.getAllAppConfig(moduleName, Integer.valueOf(pageNumber), Integer.valueOf(length == -1 ? Integer.MAX_VALUE : length));
        StringBuilder appConfigJSONData = new StringBuilder();
        appConfigJSONData.append("{\"draw\": ").append("0");
        appConfigJSONData.append(",\"recordsTotal\":").append(pagedAppConfigs.getTotalElements());
        appConfigJSONData.append(",\"totalDisplayRecords\":").append(pagedAppConfigs.getTotalElements());
        appConfigJSONData.append(",\"recordsFiltered\":").append(pagedAppConfigs.getTotalElements());
        appConfigJSONData.append(",\"data\":").append(WebUtils.toJSON((Collection)pagedAppConfigs.getContent(), AppConfig.class, AppConfigJsonAdaptor.class)).append("}");
        return appConfigJSONData.toString();
    }
}

