/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class CreateBoundaryController {
    private static final String REDIRECT_URL_VIEW = "redirect:/view-boundary/";
    private final BoundaryService boundaryService;

    @Autowired
    public CreateBoundaryController(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    @RequestMapping(value={"/boundary/create"}, method={RequestMethod.POST})
    public String createOrUpdateBoundary(@Valid @ModelAttribute Boundary boundary, BindingResult errors, RedirectAttributes redirectAttributes, Model model) {
        BoundaryType boundaryType = boundary.getBoundaryType();
        if (errors.hasErrors()) {
            model.addAttribute("boundaryType", (Object)boundaryType);
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryType.getParent().getId()));
            return "boundary-create";
        }
        this.boundaryService.createBoundary(boundary);
        redirectAttributes.addFlashAttribute("boundary", (Object)boundary);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.bndry.create.success");
        return REDIRECT_URL_VIEW + boundaryType.getHierarchyType().getId() + "," + boundaryType.getId();
    }

    @RequestMapping(value={"/wards-by-zone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getWardByZone(@RequestParam Long zoneId) throws IOException {
        return this.boundaryService.getActiveChildBoundariesByBoundaryId(zoneId);
    }
}

