/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.utils;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.utils.EGovConfig;
import org.egov.infstr.utils.LabelValueBean;
import org.hibernate.Query;
import org.hibernate.Session;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class EgovMasterDataCaching {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovMasterDataCaching.class);
    private static final String SQL_QUERY_TYPE = "sql";
    private static final String HQL_QUERY_TYPE = "hql";
    private static final String PATH_DELIM = "/";
    private static final String SQL_TAG_PREFIX = "sql.";
    private static final String CONFIG_FILE_SUFFIX = "_sqlconfig.xml";
    private static EmbeddedCacheManager CACHE_MANAGER;
    @PersistenceContext
    private EntityManager entityManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List get(String sqlTagName) throws ApplicationRuntimeException {
        String[] temp = sqlTagName.split("-");
        String domainName = ApplicationThreadLocals.getDomainName();
        String applName = temp[0];
        List dataList = null;
        HashMap cacheValuesHashMap = new HashMap();
        try {
            cacheValuesHashMap = (HashMap)CACHE_MANAGER.getCache().get((Object)(applName + PATH_DELIM + domainName + PATH_DELIM + sqlTagName));
            if (cacheValuesHashMap != null) {
                dataList = (List)cacheValuesHashMap.get(sqlTagName);
            }
            if (dataList == null || dataList.isEmpty()) {
                String type = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "type", "", SQL_TAG_PREFIX + sqlTagName).trim();
                if (type.equalsIgnoreCase("java")) {
                    String className = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "class", "", SQL_TAG_PREFIX + sqlTagName);
                    String methodName = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "method", "", SQL_TAG_PREFIX + sqlTagName);
                    String parametertype = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "parametertype", "", SQL_TAG_PREFIX + sqlTagName);
                    String parametervalue = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "parametervalue", "", SQL_TAG_PREFIX + sqlTagName);
                    if (!StringUtils.isNotBlank((String)className) || !StringUtils.isNotBlank((String)methodName)) throw new ApplicationRuntimeException("ClassName and MethodName should be mentioned for " + type + " in " + applName + CONFIG_FILE_SUFFIX);
                    dataList = this.loadJavaAPIMasterDataList(className, methodName, parametertype.split(","), parametervalue.split(","));
                } else {
                    if (!type.equalsIgnoreCase(HQL_QUERY_TYPE) && !type.equalsIgnoreCase(SQL_QUERY_TYPE)) throw new ApplicationRuntimeException("This type (" + type + ") is not supported for " + sqlTagName);
                    String query = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "query", "", SQL_TAG_PREFIX + sqlTagName);
                    if (query.equalsIgnoreCase("")) throw new ApplicationRuntimeException("Query should be mentioned for " + type + " in " + applName + CONFIG_FILE_SUFFIX);
                    dataList = this.loadQLMasterData(query, type);
                }
                HashMap<String, List> hm = new HashMap<String, List>();
                hm.put(sqlTagName, dataList);
                CACHE_MANAGER.getCache().put((Object)(applName + PATH_DELIM + domainName + PATH_DELIM + sqlTagName), hm);
                return dataList;
            } else {
                LOGGER.info("EgovMasterDataCaching: Got directly from cache, not from db");
            }
            return dataList;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching", e);
        }
    }

    public Map getMap(String sqlTagName) throws ApplicationRuntimeException {
        Map<String, String> dataMap;
        block8: {
            dataMap = new HashMap<String, String>();
            String[] temp = sqlTagName.split("-");
            String applName = temp[0];
            String domainName = ApplicationThreadLocals.getDomainName();
            String type = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "type", "", SQL_TAG_PREFIX + sqlTagName).trim();
            try {
                if (type.trim().equalsIgnoreCase(SQL_QUERY_TYPE)) {
                    List dataList = this.get(sqlTagName);
                    if (dataList != null) {
                        Iterator itr = dataList.iterator();
                        LabelValueBean obj = null;
                        while (itr.hasNext()) {
                            obj = (LabelValueBean)itr.next();
                            dataMap.put(Integer.toString(obj.getId()), obj.getName());
                            obj = null;
                        }
                    }
                    break block8;
                }
                if (type.equalsIgnoreCase(HQL_QUERY_TYPE)) {
                    throw new ApplicationRuntimeException("getMap() is not supported for HQL query");
                }
                if (type.equalsIgnoreCase("java")) {
                    String className = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "class", "", SQL_TAG_PREFIX + sqlTagName);
                    String methodName = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "method", "", SQL_TAG_PREFIX + sqlTagName);
                    String parametertype = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "parametertype", "", SQL_TAG_PREFIX + sqlTagName);
                    String parametervalue = EGovConfig.getProperty(applName + CONFIG_FILE_SUFFIX, "parametervalue", "", SQL_TAG_PREFIX + sqlTagName);
                    if (!StringUtils.isNotBlank((String)className) || !StringUtils.isNotBlank((String)methodName)) {
                        throw new ApplicationRuntimeException("ClassName and MethodName should be mentioned for " + type + " in " + applName + CONFIG_FILE_SUFFIX);
                    }
                    dataMap = this.loadJavaAPIMasterDataMap(className, methodName, parametertype.split(","), parametervalue.split(","));
                    HashMap<String, HashMap<String, String>> hm = new HashMap<String, HashMap<String, String>>();
                    hm.put(sqlTagName, (HashMap<String, String>)dataMap);
                    CACHE_MANAGER.getCache().put((Object)(applName + PATH_DELIM + domainName + PATH_DELIM + sqlTagName), hm);
                    break block8;
                }
                throw new ApplicationRuntimeException("This type (" + type + ") is not supported for " + sqlTagName);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred in EgovMasterDataCaching getMap", (Throwable)e);
                throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching getMap", e);
            }
        }
        return dataMap;
    }

    public static EmbeddedCacheManager getCACHE_MANAGER() {
        return CACHE_MANAGER;
    }

    public static void removeFromCache(String sqlTagName) throws ApplicationRuntimeException {
        try {
            String[] temp = sqlTagName.split("-");
            String domainName = ApplicationThreadLocals.getDomainName();
            String applName = temp[0];
            CACHE_MANAGER.getCache().remove((Object)(applName + PATH_DELIM + domainName + PATH_DELIM + sqlTagName));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching removeFromCache", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching removeFromCache", e);
        }
    }

    private List loadQLMasterData(String query, String queryType) throws ApplicationRuntimeException {
        List list = null;
        try {
            if (queryType.trim().equalsIgnoreCase(HQL_QUERY_TYPE)) {
                list = this.queryByHibernate(query);
            } else if (queryType.trim().equalsIgnoreCase(SQL_QUERY_TYPE)) {
                list = this.queryByJdbc(query);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching loadQLMasterData", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching loadQLMasterData", e);
        }
        return list;
    }

    private List loadJavaAPIMasterDataList(String className, String methodName, String[] parametertype, String[] parametervalue) throws ApplicationRuntimeException {
        List list = null;
        try {
            if (parametertype.length != parametervalue.length) {
                throw new ApplicationRuntimeException("Number of parameter types and parameter values doesnt match");
            }
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod(methodName, this.loadMethodParameter(parametertype));
            list = (List)method.invoke(cls.newInstance(), this.loadMethodArguments(parametertype, parametervalue));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching loadJavaAPIMasterDataList", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching loadJavaAPIMasterDataList", e);
        }
        return list;
    }

    private Map loadJavaAPIMasterDataMap(String className, String methodName, String[] parametertype, String[] parametervalue) throws ApplicationRuntimeException {
        HashMap dataMap = new HashMap();
        try {
            if (parametertype.length != parametervalue.length) {
                throw new ApplicationRuntimeException("Number of parameter types and parameter values doesnt match");
            }
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod(methodName, this.loadMethodParameter(parametertype));
            dataMap = (HashMap)method.invoke(cls.newInstance(), this.loadMethodArguments(parametertype, parametervalue));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching loadJavaAPIMasterDataMap", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching loadJavaAPIMasterDataMap", e);
        }
        return dataMap;
    }

    private Class[] loadMethodParameter(String[] parametertype) throws ApplicationRuntimeException {
        Class[] class_name = null;
        try {
            if (!parametertype[0].trim().equalsIgnoreCase("")) {
                class_name = new Class[parametertype.length];
                for (int i = 0; i < parametertype.length; ++i) {
                    class_name[i] = Class.forName(parametertype[i]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching loadMethodParameter", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching loadMethodParameter", e);
        }
        return class_name;
    }

    private Object[] loadMethodArguments(String[] parametertype, String[] parametervalue) throws ApplicationRuntimeException {
        Object[] obj_name = null;
        try {
            if (!parametertype[0].trim().equalsIgnoreCase("")) {
                obj_name = new Object[parametervalue.length];
                for (int i = 0; i < parametertype.length; ++i) {
                    if (parametertype[i].trim().equalsIgnoreCase("java.lang.Integer")) {
                        obj_name[i] = Integer.valueOf(parametervalue[i]);
                        continue;
                    }
                    if (parametertype[i].trim().equalsIgnoreCase("java.lang.Double")) {
                        obj_name[i] = Double.valueOf(parametervalue[i]);
                        continue;
                    }
                    if (parametertype[i].trim().equalsIgnoreCase("java.lang.String")) {
                        obj_name[i] = parametervalue[i];
                        continue;
                    }
                    throw new ApplicationRuntimeException("This " + parametertype[i] + " datatype is not supported");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching loadMethodArguments", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching loadMethodArguments", e);
        }
        return obj_name;
    }

    private List queryByHibernate(String query) throws ApplicationRuntimeException {
        List list = null;
        try {
            Query qry = this.getCurrentSession().createQuery(query);
            list = qry.list();
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching queryByHibernate", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching queryByHibernate", e);
        }
        return list;
    }

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private List queryByJdbc(String query) throws ApplicationRuntimeException {
        List resultlist = null;
        List returnList = null;
        try {
            resultlist = this.getCurrentSession().createSQLQuery(query).list();
            if (resultlist != null) {
                returnList = this.resultSetToArrayList(resultlist);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching queryByJdbc", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching queryByJdbc", e);
        }
        return returnList;
    }

    private List resultSetToArrayList(List<Object[]> resultList) throws ApplicationRuntimeException {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        LabelValueBean labelValueBean = null;
        try {
            for (Object[] objArr : resultList) {
                labelValueBean = new LabelValueBean();
                BigDecimal id = (BigDecimal)objArr[0];
                labelValueBean.setId(id.intValue());
                labelValueBean.setName((String)objArr[1]);
                list.add(labelValueBean);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in EgovMasterDataCaching resultSetToArrayList", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in EgovMasterDataCaching resultSetToArrayList", e);
        }
        return list;
    }

    @PreDestroy
    public void destroy() {
        if (CACHE_MANAGER != null && CACHE_MANAGER.isDefaultRunning()) {
            CACHE_MANAGER.stop();
        }
    }

    static {
        try {
            InitialContext context = new InitialContext();
            CACHE_MANAGER = (EmbeddedCacheManager)context.lookup("java:jboss/infinispan/container/master-data");
        }
        catch (NamingException e) {
            throw new ApplicationRuntimeException("Error occurred while getting Cache Manager", e);
        }
    }
}

