/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CacheControlFilter
implements Filter {
    private static final String EXPIRE_HEADER = "Expires";
    private static final String ETAG_HEADER = "ETag";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String PRAGMA_HEADER = "Pragma";
    public static final long DEFAULT_EXPIRES_SECONDS = 2592000L;
    private long expireInSeconds = 0L;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.expireInSeconds = filterConfig.getInitParameter("expireInSeconds") == null ? 2592000L : Long.valueOf(filterConfig.getInitParameter("expireInSeconds"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader(CACHE_CONTROL_HEADER, "public,max-age=" + this.expireInSeconds);
        httpServletResponse.setDateHeader(EXPIRE_HEADER, System.currentTimeMillis() + this.expireInSeconds * 1000L);
        httpServletResponse.setHeader(PRAGMA_HEADER, null);
        httpServletResponse.setHeader(ETAG_HEADER, null);
        chain.doFilter(request, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }
}

