/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Optional;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javaxt.io.Image;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class ImageUtils {
    public static final String JPG_EXTN = ".jpg";
    public static final String JPG_FORMAT_NAME = "jpeg";
    private static final Logger LOG = LoggerFactory.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static File compressImage(MultipartFile imageFile) throws IOException {
        return ImageUtils.compressImage(imageFile.getInputStream(), imageFile.getOriginalFilename(), true);
    }

    public static File compressImage(InputStream imageStream, String imageFileName, boolean closeStream) throws IOException {
        File compressedImage = Paths.get(imageFileName, new String[0]).toFile();
        try (ImageOutputStream imageOutput = ImageIO.createImageOutputStream(compressedImage);){
            ImageWriter writer = ImageIO.getImageWritersByFormatName(StringUtils.defaultString((String)FilenameUtils.getExtension((String)imageFileName), (String)JPG_FORMAT_NAME)).next();
            writer.setOutput(imageOutput);
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            if (writeParam.canWriteCompressed()) {
                writeParam.setCompressionMode(2);
                writeParam.setCompressionType(writeParam.getCompressionTypes()[0]);
                writeParam.setCompressionQuality(0.05f);
            }
            writer.write(null, new IIOImage(ImageIO.read(imageStream), null, null), writeParam);
            writer.dispose();
            if (closeStream) {
                imageStream.close();
            }
        }
        return compressedImage;
    }

    public static double[] findGeoCoordinates(File jpegImage) {
        Optional<double[]> coordinates = Optional.empty();
        if (JPG_FORMAT_NAME.equalsIgnoreCase(ImageUtils.imageFormat(jpegImage))) {
            Image image = new Image(jpegImage);
            coordinates = Optional.ofNullable(image.getGPSCoordinate());
        }
        return coordinates.orElse(new double[]{0.0, 0.0});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String imageFormat(File image) {
        try (ImageInputStream iis = ImageIO.createImageInputStream(image);){
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
            String string = imageReaders.hasNext() ? imageReaders.next().getFormatName() : "";
            return string;
        }
        catch (IOException e) {
            LOG.warn("Could not read image format from file", (Throwable)e);
            return "";
        }
    }
}

