/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.viewer;

import java.util.EnumMap;
import java.util.UUID;
import org.egov.infra.cache.impl.ApplicationCacheManager;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportViewerUtil {
    private static final EnumMap<ReportFormat, String> contentTypes = ReportViewerUtil.getContentTypes();
    @Autowired
    private ApplicationCacheManager applicationCacheManager;

    private static EnumMap<ReportFormat, String> getContentTypes() {
        EnumMap<ReportFormat, String> contentTypes = new EnumMap<ReportFormat, String>(ReportFormat.class);
        contentTypes.put(ReportFormat.PDF, "application/pdf");
        contentTypes.put(ReportFormat.XLS, "application/vnd.ms-excel");
        contentTypes.put(ReportFormat.RTF, "application/rtf");
        contentTypes.put(ReportFormat.HTM, "text/html");
        contentTypes.put(ReportFormat.TXT, "text/plain");
        contentTypes.put(ReportFormat.CSV, "text/plain");
        return contentTypes;
    }

    public static String getContentType(ReportFormat fileFormat) {
        return contentTypes.get((Object)fileFormat);
    }

    public static String getContentDisposition(ReportFormat fileFormat) {
        return "inline; filename=report." + fileFormat.toString();
    }

    public String addReportToTempCache(ReportOutput reportOutput) {
        String reportId = UUID.randomUUID().toString();
        this.applicationCacheManager.put(reportId, reportOutput);
        return reportId;
    }

    public ReportOutput getReportOutputFormCache(String reportOutputCacheKey) {
        return this.applicationCacheManager.get(reportOutputCacheKey, ReportOutput.class);
    }

    public void removeReportOutputFromCache(String reportOutputCacheKey) {
        this.applicationCacheManager.remove(reportOutputCacheKey);
    }
}

