/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.utils;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="squenceGenerator")
public class SequenceNumberGenerator {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, noRollbackFor={SQLGrammarException.class})
    public Serializable getNextSequence(String sequenceName) throws SQLGrammarException {
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery("SELECT nextval (:sequenceName) as nextval");
        query.setParameter("sequenceName", (Object)sequenceName);
        return (Serializable)query.uniqueResult();
    }
}

