/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.repository.es;

import java.util.List;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.admin.master.repository.es.CityIndexCustomRepository;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public class CityIndexRepositoryImpl
implements CityIndexCustomRepository {
    @Autowired
    private ElasticsearchTemplate elasticSearchTemplate;

    @Override
    public CityIndex findOneByDistrictCode(String districtCode) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withIndices(new String[]{"city"}).withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"districtcode", (Object)districtCode)).build();
        List cityList = this.elasticSearchTemplate.queryForList((SearchQuery)query, CityIndex.class);
        return (CityIndex)cityList.get(0);
    }

    @Override
    public CityIndex findOneByCityCode(String cityCode) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withIndices(new String[]{"city"}).withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"citycode", (Object)cityCode)).build();
        List cityList = this.elasticSearchTemplate.queryForList((SearchQuery)query, CityIndex.class);
        return (CityIndex)cityList.get(0);
    }
}

