/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.joda.time.DateTime;

@Entity
@Table(name="eg_user")
@Inheritance(strategy=InheritanceType.JOINED)
@Cacheable
@SequenceGenerator(name="SEQ_EG_USER", sequenceName="SEQ_EG_USER", allocationSize=1)
@Unique(fields={"username", "pan", "aadhaarNumber", "emailId"}, enableDfltMsg=true, isSuperclass=true)
@CompositeUnique(fields={"type", "mobileNumber"}, enableDfltMsg=true, message="{user.exist.with.same.mobileno}")
public class User
extends AbstractAuditable {
    public static final String SEQ_USER = "SEQ_EG_USER";
    private static final long serialVersionUID = -2415368058955783970L;
    @Expose
    @Id
    @GeneratedValue(generator="SEQ_EG_USER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(name="username", unique=true)
    @NotNull
    @Length(min=2, max=64)
    private String username;
    @NotNull
    @Length(min=4, max=64)
    private String password;
    private String salutation;
    @SafeHtml
    @Length(min=2, max=64)
    private String guardian;
    @SafeHtml
    @Length(min=2, max=64)
    private String guardianRelation;
    @NotNull
    @SafeHtml
    @Length(min=2, max=100)
    @Audited
    private String name;
    @Enumerated(value=EnumType.ORDINAL)
    private Gender gender;
    @Pattern(regexp="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$")
    @SafeHtml
    @Length(max=15)
    @Audited
    private String mobileNumber;
    @Email(regexp="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")
    @SafeHtml
    @Length(max=128)
    @Audited
    private String emailId;
    @SafeHtml
    private String altContactNumber;
    @SafeHtml
    @Length(max=10)
    private String pan;
    @SafeHtml
    @Length(max=20)
    private String aadhaarNumber;
    @OneToMany(mappedBy="user", cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    private List<Address> address = new ArrayList<Address>();
    private boolean active;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="eg_userrole", joinColumns={@JoinColumn(name="userid")}, inverseJoinColumns={@JoinColumn(name="roleid")})
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @AuditJoinTable
    private Set<Role> roles = new HashSet<Role>();
    @Temporal(value=TemporalType.DATE)
    private Date dob;
    @NotNull
    private Date pwdExpiryDate = new Date();
    @NotNull
    private String locale = "en_IN";
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private UserType type;
    private byte[] signature;
    private boolean accountLocked;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    protected void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public void setAltContactNumber(String altContactNumber) {
        this.altContactNumber = altContactNumber;
    }

    public String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public void setAddress(List<Address> address) {
        this.address = address;
    }

    public void addAddress(Address address) {
        address.setUser(this);
        this.address.add(address);
    }

    public void removeAddress(Address address) {
        this.getAddress().remove(address);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
    }

    public void removeRole(Role role) {
        this.getRoles().remove(role);
    }

    public Date getDob() {
        return this.dob;
    }

    public void setDob(Date dob) {
        this.dob = dob;
    }

    public DateTime getPwdExpiryDate() {
        return null == this.pwdExpiryDate ? null : new DateTime((Object)this.pwdExpiryDate);
    }

    public void setPwdExpiryDate(Date pwdExpiryDate) {
        this.pwdExpiryDate = pwdExpiryDate;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Locale locale() {
        return LocaleUtils.toLocale((String)this.locale);
    }

    public UserType getType() {
        return this.type;
    }

    public void setType(UserType userType) {
        this.type = userType;
    }

    public String getGuardian() {
        return this.guardian;
    }

    public void setGuardian(String guardian) {
        this.guardian = guardian;
    }

    public String getGuardianRelation() {
        return this.guardianRelation;
    }

    public void setGuardianRelation(String guardianRelation) {
        this.guardianRelation = guardianRelation;
    }

    @JsonIgnore
    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public boolean isAccountLocked() {
        return this.accountLocked;
    }

    public void setAccountLocked(boolean accountLocked) {
        this.accountLocked = accountLocked;
    }

    public void updateNextPwdExpiryDate(Integer passwordExpireInDays) {
        this.setPwdExpiryDate(new DateTime().plusDays(passwordExpireInDays.intValue()).toDate());
    }

    public boolean hasRole(String roleName) {
        return this.roles.parallelStream().map(Role::getName).anyMatch(roleName::equals);
    }
}

