/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.BaseModel;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Transactional(readOnly=true)
@Deprecated
public class PersistenceService<T, ID extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceService.class);
    @PersistenceContext
    protected EntityManager entityManager;
    private Class<T> type;
    @Autowired
    @Qualifier(value="entityValidator")
    private LocalValidatorFactoryBean entityValidator;

    public PersistenceService(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void validate(T model) {
        List<ValidationError> errors = this.validateModel(model);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    public List<ValidationError> validateModel(T model) {
        BaseModel basemodel;
        List<ValidationError> dependentValMessages;
        LOG.debug("Validating Model");
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (model == null) {
            errors.add(new ValidationError("", "model.null"));
            return errors;
        }
        Set constraintViolations = this.entityValidator.validate(model, new Class[0]);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            Iterator nodes = constraintViolation.getPropertyPath().iterator();
            while (nodes.hasNext()) {
                errors.add(new ValidationError(((Path.Node)nodes.next()).getName(), constraintViolation.getMessage()));
            }
        }
        if (model instanceof BaseModel && (dependentValMessages = (basemodel = (BaseModel)model).validate()) != null) {
            errors.addAll(dependentValMessages);
        }
        return errors;
    }

    public T find(String query, Object ... params) {
        List<T> results = this.findAllBy(query, params);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    public T find(String query) {
        Query q = this.getSession().createQuery(query);
        return (T)q.uniqueResult();
    }

    protected T findById(ID id) {
        return (T)(id == null ? null : this.getSession().get(this.type, id));
    }

    public List<T> findAllBy(String query, Object ... params) {
        Query q = this.getQueryWithParams(query, params);
        return q.list();
    }

    public Page findPageBy(String query, Integer pageNumber, Integer pageSize, Object ... params) {
        Query q = this.getQueryWithParams(query, params);
        return new Page(q, (int)pageNumber, (int)pageSize);
    }

    private Query getQueryWithParams(String query, Object ... params) {
        Query q = this.getSession().createQuery(query);
        int index = 0;
        for (Object param : params) {
            q.setParameter(index, param);
            ++index;
        }
        return q;
    }

    public List<T> findAllByNamedQuery(String namedQuery, Object ... params) {
        Query q = this.getNamedQueryWithParams(namedQuery, params);
        return q.list();
    }

    public Page findPageByNamedQuery(String namedQuery, Integer pageNumber, Integer pageSize, Object ... params) {
        Query q = this.getNamedQueryWithParams(namedQuery, params);
        return new Page(q, (int)pageNumber, (int)pageSize);
    }

    private Query getNamedQueryWithParams(String namedQuery, Object ... params) {
        Query q = this.getSession().getNamedQuery(namedQuery);
        int index = 0;
        for (Object param : params) {
            if (param instanceof Collection) {
                q.setParameterList(String.valueOf("param_" + index), (Collection)param);
            } else {
                q.setParameter(index, param);
            }
            ++index;
        }
        return q;
    }

    public T findByNamedQuery(String namedQuery, Object ... params) {
        List<T> results = this.findAllByNamedQuery(namedQuery, params);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Transactional
    public T persist(T model) {
        this.validate(model);
        this.getSession().saveOrUpdate(model);
        return model;
    }

    @Transactional
    public T merge(T model) {
        this.validate(model);
        return (T)this.getSession().merge(model);
    }

    @Transactional
    public T create(T entity) {
        this.validate(entity);
        Long id = (Long)this.getSession().save(entity);
        return (T)this.getSession().load(this.type, (Serializable)id);
    }

    public T load(Serializable id, Class cls) {
        return (T)this.getSession().load(cls, id);
    }

    @Transactional
    public void delete(T entity) {
        this.getSession().delete(entity);
    }

    public List<T> findAll() {
        return this.getSession().createCriteria(this.type).list();
    }

    public List<T> findByExample(T exampleT) {
        Criteria criteria = this.getSession().createCriteria(this.type);
        return criteria.add((Criterion)Example.create(exampleT)).list();
    }

    public T findById(ID id, boolean lock) {
        return this.findById(id);
    }

    public T findByIdWithJoinFetch(ID id, String joinFetchPropertyName) {
        return (T)this.getSession().createCriteria(this.type).setFetchMode(joinFetchPropertyName, FetchMode.JOIN).add(Restrictions.idEq(id)).uniqueResult();
    }

    @Transactional
    public T update(T entity) {
        this.validate(entity);
        this.getSession().update(entity);
        return entity;
    }

    public List<T> findAll(String ... orderByFields) {
        Criteria c = this.getSession().createCriteria(this.type);
        for (String orderBy : orderByFields) {
            c.addOrder(Order.asc((String)orderBy).ignoreCase());
        }
        return c.list();
    }

    public String getNamedQuery(String namedQuery) {
        return this.getSession().getNamedQuery(namedQuery).getQueryString();
    }

    public void addIndexparams(Map<String, List> indexparams, String key, Object ... values) {
        ArrayList<Object> objparams = new ArrayList<Object>();
        for (Object value : values) {
            objparams.add(value);
        }
        indexparams.put(key, objparams);
    }

    public void addFilterCriteriaForObject(Map<String, List> params, Criteria c, String ... orderbyFields) {
        for (Map.Entry<String, List> entry : params.entrySet()) {
            if (entry.getKey().contains("date") || entry.getKey().contains("Date")) {
                c.add(Restrictions.between((String)entry.getKey(), entry.getValue().get(0), entry.getValue().get(1)));
                continue;
            }
            c.add((Criterion)Restrictions.eq((String)entry.getKey(), entry.getValue().get(0)));
        }
        for (String orderBy : orderbyFields) {
            c.addOrder(Order.asc((String)orderBy).ignoreCase());
        }
    }

    public void applyAuditing(AbstractAuditable auditable) {
        Date currentDate = new Date();
        if (auditable.isNew()) {
            auditable.setCreatedBy((User)this.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            auditable.setCreatedDate(currentDate);
        }
        auditable.setLastModifiedBy((User)this.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        auditable.setLastModifiedDate(currentDate);
    }

    public void applyAuditing(BaseModel baseModel) {
        Date currentDate = new Date();
        if (baseModel.getId() == null) {
            baseModel.setCreatedBy((User)this.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
            baseModel.setCreatedDate(currentDate);
        }
        baseModel.setModifiedBy((User)this.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        baseModel.setModifiedDate(currentDate);
    }
}

