/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.util.List;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowAdditionalRule;
import org.egov.infra.workflow.matrix.repository.WorkFlowAdditionalRuleRepository;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkFlowAdditionalDetailsService {
    public static final String OBJECTTYPEID_ID = "objecttypeid.id";
    public static final String ADDITIONAL_RULE = "additionalRule";
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    private WorkFlowAdditionalRuleRepository workFlowAdditionalRuleRepository;

    public List getAllModuleTypeforStatus() {
        return this.entityQueryService.findAllBy(" select distinct(moduletype) from EgwStatus order by moduletype asc", new Object[0]);
    }

    public List<WorkflowTypes> getobjectTypeList() {
        return this.workflowTypeService.getAllWorkflowTypes();
    }

    @Transactional
    public WorkFlowAdditionalRule save(WorkFlowAdditionalRule wfAdditionalRule) {
        return (WorkFlowAdditionalRule)this.workFlowAdditionalRuleRepository.save(wfAdditionalRule);
    }

    public List<WorkFlowAdditionalRule> getAdditionalRulesbyObject(Long objectType) {
        return this.entityQueryService.getSession().createCriteria(WorkFlowAdditionalRule.class).add((Criterion)Restrictions.eq((String)OBJECTTYPEID_ID, (Object)objectType)).list();
    }

    public WorkFlowAdditionalRule getObjectbyTypeandRule(Long objectType, String additionalRules) {
        Criteria crit = this.entityQueryService.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)OBJECTTYPEID_ID, (Object)objectType));
        if ("-1".equals(additionalRules)) {
            crit.add(Restrictions.isNull((String)ADDITIONAL_RULE));
        } else {
            crit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, (Object)additionalRules));
        }
        List wfAdditionalRules = crit.list();
        if (!wfAdditionalRules.isEmpty()) {
            return (WorkFlowAdditionalRule)wfAdditionalRules.get(0);
        }
        return null;
    }

    public WorkFlowAdditionalRule getObjectbyTypeandRule(Long objectId, Long objectType, String additionalRules) {
        Criteria crit = this.entityQueryService.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)OBJECTTYPEID_ID, (Object)objectType));
        crit.add((Criterion)Restrictions.ne((String)"id", (Object)objectId));
        if (additionalRules == null) {
            crit.add(Restrictions.isNull((String)ADDITIONAL_RULE));
        } else {
            crit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, (Object)additionalRules));
        }
        List wfAdditionalRules = crit.list();
        if (!wfAdditionalRules.isEmpty()) {
            return (WorkFlowAdditionalRule)wfAdditionalRules.get(0);
        }
        return null;
    }
}

