/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.WorkflowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CustomizedWorkFlowService {
    @Autowired
    @Qualifier(value="workflowService")
    private WorkflowService<? extends StateAware> workflowService;

    public List<String> getNextDesignationsForActiveAssignments(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        return this.getDesignationNames(this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date));
    }

    public List<String> getNextDesignationsForActiveAssignments(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date, String designation) {
        return this.getDesignationNames(this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date, designation));
    }

    public List<String> getNextDesignations(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        return this.getDesignationNames(this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date));
    }

    public List<String> getNextDesignations(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date, String designation) {
        return this.getDesignationNames(this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date, designation));
    }

    public List<String> getNextValidActions(String type, String departmentName, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, departmentName, businessRule, additionalRule, currentState, pendingAction);
        List<String> validActions = Collections.emptyList();
        if (wfMatrix != null && wfMatrix.getValidActions() != null) {
            validActions = Arrays.asList(wfMatrix.getValidActions().split(","));
        }
        return validActions;
    }

    public List<String> getNextValidActions(String type, String departmentName, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, departmentName, businessRule, additionalRule, currentState, pendingAction, date);
        List<String> validActions = Collections.emptyList();
        if (wfMatrix != null && wfMatrix.getValidActions() != null) {
            validActions = Arrays.asList(wfMatrix.getValidActions().split(","));
        }
        return validActions;
    }

    public List<String> getNextValidActions(String type, String departmentName, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date, String currentDesignation) {
        WorkFlowMatrix wfMatrix = this.workflowService.getWfMatrix(type, departmentName, businessRule, additionalRule, currentState, pendingAction, date, currentDesignation);
        List<String> validActions = Collections.emptyList();
        if (wfMatrix != null && wfMatrix.getValidActions() != null) {
            validActions = Arrays.asList(wfMatrix.getValidActions().split(","));
        }
        return validActions;
    }

    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date) {
        return this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date);
    }

    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction, Date date, String currentDesignation) {
        return this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction, date, currentDesignation);
    }

    public WorkFlowMatrix getWfMatrix(String type, String department, BigDecimal businessRule, String additionalRule, String currentState, String pendingAction) {
        return this.workflowService.getWfMatrix(type, department, businessRule, additionalRule, currentState, pendingAction);
    }

    private List<String> getDesignationNames(WorkFlowMatrix wfMatrix) {
        ArrayList<String> designationNames = new ArrayList<String>();
        if (wfMatrix != null && wfMatrix.getNextDesignation() != null) {
            List<String> tempDesignationName = Arrays.asList(wfMatrix.getNextDesignation().split(","));
            for (String desgName : tempDesignationName) {
                if (desgName == null || "".equals(desgName.trim())) continue;
                designationNames.add(desgName.toUpperCase());
            }
        }
        return designationNames;
    }
}

