/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.inbox;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.microservice.utils.MicroserviceUtils;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.web.support.ui.Inbox;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infra.workflow.service.OwnerGroupService;
import org.egov.infra.workflow.service.StateService;
import org.egov.infra.workflow.service.WorkflowActionService;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InboxRenderServiceDelegate<T extends StateAware> {
    private static final Logger LOG = LoggerFactory.getLogger(InboxRenderServiceDelegate.class);
    private static final String INBOX_RENDER_SERVICE_SUFFIX = "%sInboxRenderService";
    private static final Map<String, WorkflowTypes> WORKFLOW_TYPE_CACHE = new ConcurrentHashMap<String, WorkflowTypes>();
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private StateService stateService;
    @Autowired
    @Qualifier(value="eisService")
    private OwnerGroupService<? extends OwnerGroup> ownerGroupService;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    private WorkflowActionService workflowActionService;
    @Autowired
    private MicroserviceUtils microserviceUtils;

    @ReadOnly
    public List<Inbox> getCurrentUserInboxItems() {
        return this.buildInbox(this.getAssignedWorkflowItems()).parallelStream().filter(item -> !item.isDraft()).collect(Collectors.toList());
    }

    @ReadOnly
    public List<Inbox> getCurrentUserDraftItems() {
        return this.buildInbox(this.getAssignedWorkflowDrafts());
    }

    @ReadOnly
    public List<Inbox> getWorkflowHistoryItems(Long stateId) {
        LinkedList<Inbox> inboxHistoryItems = new LinkedList<Inbox>();
        for (StateHistory stateHistory : this.getStateHistory(stateId)) {
            inboxHistoryItems.add(Inbox.buildHistory(stateHistory, this.getWorkflowType(stateHistory.getState().getType())));
        }
        return inboxHistoryItems;
    }

    @ReadOnly
    public List<T> getAssignedWorkflowItems() {
        return this.getAssignedWorkflowItems(false);
    }

    @ReadOnly
    public List<T> getAssignedWorkflowDrafts() {
        return this.getAssignedWorkflowItems(true);
    }

    @ReadOnly
    public List<StateHistory> getStateHistory(Long stateId) {
        return new LinkedList<StateHistory>(this.stateService.getStateById(stateId).getHistory());
    }

    private List<T> getAssignedWorkflowItems(boolean draft) {
        ArrayList<T> workflowItems = new ArrayList<T>();
        List<Long> owners = this.currentUserPositionIds();
        if (!owners.isEmpty()) {
            List<String> types = this.stateService.getAssignedWorkflowTypeNames(owners);
            for (String type : types) {
                Optional<InboxRenderService<T>> inboxRenderService = this.getInboxRenderService(type);
                if (!inboxRenderService.isPresent()) continue;
                InboxRenderService<T> renderService = inboxRenderService.get();
                workflowItems.addAll(draft ? renderService.getDraftWorkflowItems(owners) : renderService.getAssignedWorkflowItems(owners));
            }
        }
        return workflowItems;
    }

    private List<Inbox> buildInbox(List<T> items) {
        ArrayList<Inbox> inboxItems = new ArrayList<Inbox>();
        for (StateAware stateAware : items) {
            inboxItems.add(Inbox.build(stateAware, this.getWorkflowType(stateAware.getStateType()), this.getNextAction(stateAware.getState())));
        }
        inboxItems.addAll(this.microserviceUtils.getInboxItems());
        return inboxItems.stream().sorted(Comparator.comparing(Inbox::getCreatedDate).reversed()).collect(Collectors.toList());
    }

    private Optional<InboxRenderService<T>> getInboxRenderService(String type) {
        InboxRenderService inboxRenderService = null;
        try {
            if (this.getWorkflowType(type) != null) {
                inboxRenderService = (InboxRenderService)this.applicationContext.getBean(String.format(INBOX_RENDER_SERVICE_SUFFIX, type), InboxRenderService.class);
            }
        }
        catch (BeansException e) {
            LOG.warn("{}InboxRenderService bean not defined", (Object)type, (Object)e);
        }
        return Optional.ofNullable(inboxRenderService);
    }

    private String getNextAction(State state) {
        String nextAction = "";
        if (state.getNextAction() != null) {
            WorkflowAction workflowAction = this.workflowActionService.getWorkflowActionByNameAndType(state.getNextAction(), state.getType());
            nextAction = workflowAction == null ? state.getNextAction() : (workflowAction.getDescription() == null ? state.getNextAction() : workflowAction.getDescription());
        }
        return nextAction;
    }

    private WorkflowTypes getWorkflowType(String type) {
        WorkflowTypes workflowType = WORKFLOW_TYPE_CACHE.get(type);
        if (workflowType == null && (workflowType = this.workflowTypeService.getEnabledWorkflowTypeByType(type)) != null) {
            WORKFLOW_TYPE_CACHE.put(type, workflowType);
        }
        return workflowType;
    }

    private List<Long> currentUserPositionIds() {
        return this.ownerGroupService.getOwnerGroupsByUserId(ApplicationThreadLocals.getUserId()).parallelStream().map(AbstractPersistable::getId).collect(Collectors.toList());
    }
}

