/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateHistory;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EG_WF_STATES")
@SequenceGenerator(name="SEQ_EG_WF_STATES", sequenceName="SEQ_EG_WF_STATES", allocationSize=1)
public class State<T extends OwnerGroup>
extends AbstractAuditable {
    public static final String DEFAULT_STATE_VALUE_CREATED = "Created";
    public static final String DEFAULT_STATE_VALUE_CLOSED = "Closed";
    public static final String STATE_REOPENED = "Reopened";
    protected static final String SEQ_STATE = "SEQ_EG_WF_STATES";
    private static final long serialVersionUID = -9159043292636575746L;
    @Id
    @GeneratedValue(generator="SEQ_EG_WF_STATES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @Length(max=255)
    @SafeHtml
    private String type;
    @NotBlank
    @Length(max=255)
    @SafeHtml
    private String value;
    @ManyToOne(targetEntity=OwnerGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_POS")
    private T ownerPosition;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_USER")
    private User ownerUser;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.LAZY, mappedBy="state", targetEntity=StateHistory.class)
    @OrderBy(value="id")
    private Set<StateHistory<T>> history = new HashSet<StateHistory<T>>();
    @Length(max=100)
    @SafeHtml
    private String senderName;
    @Length(max=255)
    @SafeHtml
    private String nextAction;
    @Length(max=1024)
    @SafeHtml
    private String comments;
    @Length(max=100)
    @SafeHtml
    private String natureOfTask;
    @Length(max=1024)
    @SafeHtml
    private String extraInfo;
    private Date dateInfo;
    private Date extraDateInfo;
    @Enumerated(value=EnumType.ORDINAL)
    @NotNull
    private StateStatus status;
    @ManyToOne(targetEntity=OwnerGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="INITIATOR_POS")
    private T initiatorPosition;
    @ManyToOne(targetEntity=OwnerGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="previousOwner")
    private T previousOwner;
    @ManyToOne(targetEntity=State.class, fetch=FetchType.LAZY)
    @JoinColumn(name="previousStateRef")
    private State<T> previousStateRef;

    protected State() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    protected void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    public T getOwnerPosition() {
        return this.ownerPosition;
    }

    protected void setOwnerPosition(T ownerPosition) {
        this.ownerPosition = ownerPosition;
    }

    public User getOwnerUser() {
        return this.ownerUser;
    }

    protected void setOwnerUser(User ownerUser) {
        this.ownerUser = ownerUser;
    }

    public Set<StateHistory<T>> getHistory() {
        return this.history;
    }

    protected void setHistory(Set<StateHistory<T>> history) {
        this.history = history;
    }

    protected void addStateHistory(StateHistory history) {
        this.getHistory().add(history);
    }

    public String getSenderName() {
        return this.senderName;
    }

    protected void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    protected void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public String getComments() {
        return this.comments;
    }

    protected void setComments(String comments) {
        this.comments = comments;
    }

    public String getNatureOfTask() {
        return this.natureOfTask;
    }

    protected void setNatureOfTask(String natureOfTask) {
        this.natureOfTask = natureOfTask;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    protected void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Date getDateInfo() {
        return this.dateInfo;
    }

    protected void setDateInfo(Date dateInfo) {
        this.dateInfo = dateInfo;
    }

    public Date getExtraDateInfo() {
        return this.extraDateInfo;
    }

    protected void setExtraDateInfo(Date extraDateInfo) {
        this.extraDateInfo = extraDateInfo;
    }

    protected StateStatus getStatus() {
        return this.status;
    }

    protected void setStatus(StateStatus status) {
        this.status = status;
    }

    @Override
    public boolean isNew() {
        return this.status.equals((Object)StateStatus.STARTED);
    }

    public boolean isEnded() {
        return this.status.equals((Object)StateStatus.ENDED);
    }

    public boolean isInprogress() {
        return this.status.equals((Object)StateStatus.INPROGRESS);
    }

    public T getInitiatorPosition() {
        return this.initiatorPosition;
    }

    protected void setInitiatorPosition(T initiatorPosition) {
        this.initiatorPosition = initiatorPosition;
    }

    public T getPreviousOwner() {
        return this.previousOwner;
    }

    protected void setPreviousOwner(T previousOwner) {
        this.previousOwner = previousOwner;
    }

    public State getPreviousStateRef() {
        return this.previousStateRef;
    }

    protected void setPreviousStateRef(State previousStateRef) {
        this.previousStateRef = previousStateRef;
    }

    public <S> S extraInfoAs(Class<S> type) {
        return JsonUtils.fromJSON(this.getExtraInfo(), type);
    }

    public static enum StateStatus {
        STARTED,
        INPROGRESS,
        ENDED;

    }
}

