/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.taglib;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.jsp.JspTagException;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.ActionService;
import org.egov.infra.security.utils.AuthorizeRule;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class EgovAuthorizeTag
extends RequestContextAwareTag {
    private static final long serialVersionUID = 1L;
    private Long actionId;
    private String actionName;
    private AuthorizeRule ruleObject;

    public Long getActionId() {
        return this.actionId;
    }

    public void setActionId(Long actionId) {
        this.actionId = actionId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public AuthorizeRule getRuleObject() {
        return this.ruleObject;
    }

    public void setRuleObject(AuthorizeRule rule) {
        this.ruleObject = rule;
    }

    public int doStartTagInternal() throws JspTagException {
        Set<Role> actionRoles;
        Set grantedCopy;
        Action action = null;
        Set userRoles = this.getPrincipalRoles();
        if (!(null != this.actionId && 0L < this.actionId || null != this.actionName && !"".equals(this.actionName) || null != this.ruleObject)) {
            return 0;
        }
        if (this.ruleObject != null) {
            // empty if block
        }
        ActionService rbacService = (ActionService)this.getRequestContext().getWebApplicationContext().getBean("actionService");
        if (this.actionName != null) {
            action = rbacService.getActionByName(this.actionName);
        }
        if (this.actionId != null) {
            action = rbacService.getActionById(this.actionId);
        }
        if (action != null && (grantedCopy = this.retainAll(userRoles, actionRoles = action.getRoles())).isEmpty()) {
            return 0;
        }
        return 1;
    }

    private Set getPrincipalRoles() {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (null == currentUser) {
            return Collections.EMPTY_SET;
        }
        if (null == currentUser.getAuthorities() || currentUser.getAuthorities().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> grantedRoles = new HashSet<String>();
        for (GrantedAuthority authority : currentUser.getAuthorities()) {
            grantedRoles.add(authority.getAuthority());
        }
        return grantedRoles;
    }

    private Set retainAll(Set<String> granted, Set<Role> required) {
        HashSet<String> requiredRoles = new HashSet<String>();
        for (Role role : required) {
            requiredRoles.add(role.getName());
        }
        granted.retainAll(requiredRoles);
        return granted;
    }
}

