/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.ui;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowTypes;

public class Inbox {
    private String id;
    private String sender;
    private String date;
    private String task;
    private String status;
    private String details;
    private String link;
    private String moduleName;
    private Date createdDate;
    private boolean draft;

    public Inbox() {
    }

    private Inbox(StateAware stateAware, WorkflowTypes workflowTypes, String nextAction) {
        State state = stateAware.getCurrentState();
        this.setId(workflowTypes.isGrouped() ? "" : state.getId() + "#" + workflowTypes.getId());
        this.setDate(DateUtils.toDefaultDateTimeFormat(state.getCreatedDate()));
        this.setSender(state.getSenderName());
        this.setTask(StringUtils.isBlank((CharSequence)state.getNatureOfTask()) ? workflowTypes.getDisplayName() : state.getNatureOfTask());
        this.setStatus(state.getValue() + (StringUtils.isBlank((CharSequence)nextAction) ? "" : " - " + nextAction));
        this.setDetails(StringUtils.isBlank((CharSequence)stateAware.getStateDetails()) ? "" : stateAware.getStateDetails());
        this.setLink(workflowTypes.getLink().replace(":ID", stateAware.myLinkId()));
        this.setModuleName(workflowTypes.getModule().getDisplayName());
        this.setCreatedDate(state.getCreatedDate());
        this.setDraft(state.isNew() && state.getCreatedBy().getId().equals(ApplicationThreadLocals.getUserId()));
    }

    private Inbox(StateHistory stateHistory, WorkflowTypes workflowTypes) {
        this.setId(stateHistory.getState().getId().toString());
        this.setDate(DateUtils.toDefaultDateTimeFormat(stateHistory.getLastModifiedDate()));
        this.setSender(stateHistory.getSenderName());
        this.setTask(StringUtils.isBlank((CharSequence)stateHistory.getNatureOfTask()) ? workflowTypes.getDisplayName() : stateHistory.getNatureOfTask());
        this.setStatus(stateHistory.getValue() + (StringUtils.isBlank((CharSequence)stateHistory.getNextAction()) ? "" : " - " + stateHistory.getNextAction()));
        this.setDetails(StringUtils.isBlank((CharSequence)stateHistory.getComments()) ? "" : org.egov.infra.utils.StringUtils.escapeSpecialChars(stateHistory.getComments()));
        this.setLink("");
    }

    public static Inbox build(StateAware stateAware, WorkflowTypes workflowType, String nextAction) {
        return new Inbox(stateAware, workflowType, nextAction);
    }

    public static Inbox buildHistory(StateHistory stateHistory, WorkflowTypes workflowType) {
        return new Inbox(stateHistory, workflowType);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }
}

