/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.ui;

import com.google.gson.JsonSerializer;
import java.util.List;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.springframework.data.domain.Page;

public class DataTable<T> {
    private long draw;
    private long recordsTotal;
    private long totalDisplayRecords;
    private long recordsFiltered;
    private List<T> data;

    public DataTable(Page<T> pages, long draw) {
        this(draw, pages.getTotalElements(), pages.getNumber(), pages.getTotalElements(), pages.getContent());
    }

    public DataTable(org.egov.infra.persistence.utils.Page<T> pages, long draw) {
        this(draw, pages.getRecordTotal(), pages.getPageSize(), pages.getRecordTotal(), pages.getList());
    }

    public DataTable(long draw, long recordsTotal, long totalDisplayRecords, long recordsFiltered, List<T> data) {
        this.draw = draw;
        this.recordsTotal = recordsTotal;
        this.totalDisplayRecords = totalDisplayRecords;
        this.recordsFiltered = recordsFiltered;
        this.data = data;
    }

    public long getDraw() {
        return this.draw;
    }

    public long getRecordsTotal() {
        return this.recordsTotal;
    }

    public long getTotalDisplayRecords() {
        return this.totalDisplayRecords;
    }

    public long getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public String toJson(Class<? extends JsonSerializer<DataTable<T>>> jsonSerializerClazz) {
        return JsonUtils.toJSON(this, jsonSerializerClazz);
    }

    public String toJson(DataTableJsonAdapter jsonSerializer) {
        return JsonUtils.toJSON(this, jsonSerializer);
    }
}

