/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.search;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.JsonUtils;
import org.springframework.data.domain.Sort;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataTableSearchRequest {
    private DataTableSearchParam searchParam;

    public int pageNumber() {
        return this.searchParam.getPageNumber();
    }

    public int pageSize() {
        return this.searchParam.getPageSize();
    }

    public int draw() {
        return this.searchParam.getDraw();
    }

    public String orderBy() {
        return this.searchParam.orderBy();
    }

    public Sort.Direction orderDir() {
        return Sort.Direction.fromString((String)this.searchParam.orderDir());
    }

    public void setArgs(String args) {
        this.searchParam = JsonUtils.fromJSON(args, DataTableSearchParam.class);
    }

    private static class Order {
        private int column;
        private String dir;

        private Order() {
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }
    }

    private static class Columns {
        private String data;
        private String name;
        private boolean orderable;

        private Columns() {
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isOrderable() {
            return this.orderable;
        }

        public void setOrderable(boolean orderable) {
            this.orderable = orderable;
        }
    }

    private static class DataTableSearchParam {
        private int start;
        private int length;
        private int draw;
        private List<Columns> columns;
        private List<Order> order;

        private DataTableSearchParam() {
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPageNumber() {
            return this.start / this.length + 1 - 1;
        }

        public int getPageSize() {
            return this.length == -1 ? Integer.MAX_VALUE : this.length;
        }

        public int getDraw() {
            return this.draw;
        }

        public void setDraw(int draw) {
            this.draw = draw;
        }

        public String orderBy() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.columns.get(this.order.get(0).column).name, (CharSequence)"id");
        }

        public String orderDir() {
            return this.order.get(0).dir;
        }

        public void setColumns(List<Columns> columns) {
            this.columns = columns;
        }

        public void setOrder(List<Order> order) {
            this.order = order;
        }
    }
}

