/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.json.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;

public class BoundaryDatatableAdapter
implements DataTableJsonAdapter<Boundary> {
    public JsonElement serialize(DataTable<Boundary> boundaryDataTable, Type type, JsonSerializationContext jsc) {
        List<Boundary> boundaries = boundaryDataTable.getData();
        JsonArray boundaryJsonData = new JsonArray();
        boundaries.forEach(boundary -> {
            JsonObject boundaryJson = new JsonObject();
            boundaryJson.addProperty("id", (Number)boundary.getId());
            boundaryJson.addProperty("name", boundary.getName());
            boundaryJson.addProperty("boundaryNameLocal", StringUtils.defaultIfBlank(boundary.getLocalName()));
            boundaryJson.addProperty("boundaryParentName", boundary.getParent() == null ? "N/A" : boundary.getParent().getName());
            boundaryJson.addProperty("boundaryNum", (Number)boundary.getBoundaryNum());
            boundaryJson.addProperty("active", StringUtils.toYesOrNo(boundary.isActive()));
            boundaryJson.addProperty("fromDate", DateUtils.toDefaultDateFormat(boundary.getFromDate()));
            boundaryJson.addProperty("toDate", boundary.getToDate() == null ? "N/A" : DateUtils.toDefaultDateFormat(boundary.getToDate()));
            boundaryJsonData.add((JsonElement)boundaryJson);
        });
        return this.enhance((JsonElement)boundaryJsonData, boundaryDataTable);
    }
}

