/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.json.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;

public class BoundaryAdapter
implements JsonSerializer<Boundary> {
    public JsonElement serialize(Boundary boundary, Type type, JsonSerializationContext jsc) {
        JsonObject boundaryJson = new JsonObject();
        boundaryJson.addProperty("id", (Number)boundary.getId());
        boundaryJson.addProperty("name", boundary.getName());
        boundaryJson.addProperty("boundaryNameLocal", StringUtils.defaultIfBlank(boundary.getLocalName()));
        boundaryJson.addProperty("boundaryParentName", boundary.getParent() == null ? "N/A" : boundary.getParent().getName());
        boundaryJson.addProperty("boundaryNum", (Number)boundary.getBoundaryNum());
        boundaryJson.addProperty("fromDate", DateUtils.toDefaultDateFormat(boundary.getFromDate()));
        boundaryJson.addProperty("toDate", boundary.getToDate() == null ? "N/A" : DateUtils.toDefaultDateFormat(boundary.getToDate()));
        return boundaryJson;
    }
}

