/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.utils.WebUtils;
import org.slf4j.MDC;

public class MDCLoggingFilter
implements Filter {
    private static final String ULBCODE = "ulbcode";
    private static final String APPNAME = "appname";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            MDC.put((String)ULBCODE, (String)ApplicationThreadLocals.getCityName());
            MDC.put((String)APPNAME, (String)WebUtils.currentContextPath(request).toUpperCase());
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

