/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.security.authentication.userdetail.CurrentUser;
import org.egov.infra.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;

public class ApplicationCoreFilter
implements Filter {
    @Autowired
    private CityService cityService;
    @Autowired
    private SecurityUtils securityUtils;
    @Value(value="${cdn.domain.url}")
    private String cdnURL;
    @Value(value="${app.version}_${app.build.no}")
    private String applicationRelease;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession();
        try {
            this.prepareUserSession(session);
            this.prepareApplicationThreadLocal(session);
            chain.doFilter((ServletRequest)request, resp);
        }
        finally {
            ApplicationThreadLocals.clearValues();
        }
    }

    private void prepareUserSession(HttpSession session) {
        if (session.getAttribute("cityCode") == null) {
            this.cityService.cityDataAsMap().forEach((arg_0, arg_1) -> ((HttpSession)session).setAttribute(arg_0, arg_1));
        }
        if (session.getAttribute("app_release_no") == null) {
            session.setAttribute("app_release_no", (Object)this.applicationRelease);
        }
        if (session.getAttribute("tenant_id") == null) {
            session.setAttribute("tenant_id", (Object)ApplicationThreadLocals.getTenantID());
        }
        if (session.getServletContext().getAttribute("cdn") == null) {
            session.getServletContext().setAttribute("cdn", (Object)this.cdnURL);
        }
        if (session.getAttribute("userid") == null) {
            Optional<Authentication> authentication = SecurityUtils.getCurrentAuthentication();
            if (authentication.isPresent() && authentication.get().getPrincipal() instanceof CurrentUser) {
                session.setAttribute("userid", (Object)((CurrentUser)authentication.get().getPrincipal()).getUserId());
            } else if (!authentication.isPresent() || !(authentication.get().getPrincipal() instanceof User)) {
                session.setAttribute("userid", (Object)this.securityUtils.getCurrentUser().getId());
            }
        }
    }

    private void prepareApplicationThreadLocal(HttpSession session) {
        ApplicationThreadLocals.setCityCode((String)session.getAttribute("cityCode"));
        ApplicationThreadLocals.setCityName((String)session.getAttribute("cityname"));
        ApplicationThreadLocals.setMunicipalityName((String)session.getAttribute("citymunicipalityname"));
        ApplicationThreadLocals.setUserId((Long)session.getAttribute("userid"));
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

