/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.text.RandomStringGenerator;
import org.egov.infra.utils.DateUtils;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static final RandomStringGenerator UNIQUE_STRING_GENERATOR = new RandomStringGenerator.Builder().withinRange(97, 122).build();

    public static String escapeSpecialChars(String str) {
        return str.replaceAll("\\s\\s+|\\r\\n", "<br/>").replaceAll("'", "\\\\'");
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public static List<String> toList(String ... values) {
        return Arrays.asList(values);
    }

    public static String encodeString(String string) {
        return org.apache.commons.lang3.StringUtils.toEncodedString((byte[])string.getBytes(), (Charset)Charset.forName("UTF-8"));
    }

    public static String[] listToStringArray(List<String> values) {
        return (String[])values.stream().toArray(String[]::new);
    }

    public static String toYesOrNo(boolean value) {
        return value ? "Yes" : "No";
    }

    public static String defaultIfBlank(String value) {
        return StringUtils.defaultIfBlank((String)value, (String)"N/A");
    }

    public static String appendTimestamp(String name) {
        return name + "_" + DateUtils.currentDateToFileNameFormat();
    }

    public static String append(String value, String append) {
        return value + append;
    }

    public static String prepend(String value, String prepend) {
        return prepend + value;
    }

    public static boolean isUnsignedNumber(String value) {
        return StringUtils.isNotBlank((String)value) && value.matches("^\\d*\\.?\\d*$");
    }

    public static String stripExtraSpaces(String value) {
        return value.trim().replaceAll("\\s{2,}", " ");
    }

    public static String uniqueString(int codePoint) {
        return UNIQUE_STRING_GENERATOR.generate(codePoint);
    }
}

