/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.egov.infra.exception.ApplicationRuntimeException;

public final class PdfUtils {
    private PdfUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] appendFiles(List<InputStream> pdfStreams) {
        try (ByteArrayOutputStream destination = new ByteArrayOutputStream();){
            PDFMergerUtility pdfMerger = new PDFMergerUtility();
            pdfMerger.setDestinationStream((OutputStream)destination);
            pdfStreams.forEach(arg_0 -> ((PDFMergerUtility)pdfMerger).addSource(arg_0));
            pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            byte[] byArray = destination.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error occurred while merging pdf files", e);
        }
    }
}

