/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberToWordConverter;

public class NumberUtil {
    private static final int AMOUNT_PRECISION_DEFAULT = 2;

    public static String amountInWords(BigDecimal amount) {
        return NumberToWordConverter.amountInWordsWithCircumfix(amount);
    }

    public static String formatNumber(BigDecimal number) {
        return NumberUtil.formatNumber(number, NumberFormatStyle.CRORES);
    }

    public static String formatNumber(BigDecimal number, NumberFormatStyle format) {
        switch (format) {
            case MILLIONS: {
                return NumberUtil.formatNumber(number, 2, true);
            }
            case CRORES: {
                return Math.abs(number.doubleValue()) >= 100000.0 ? NumberUtil.formatNumberCroreFormat(number) : NumberUtil.formatNumber(number, 2, true);
            }
        }
        throw new ApplicationRuntimeException("Invalid number format [" + (Object)((Object)format) + "]");
    }

    private static String formatNumberCroreFormat(BigDecimal num) {
        double absAmount = num.abs().doubleValue();
        long numLakhs = (long)(absAmount / 100000.0);
        double numThousands = absAmount - (double)(numLakhs * 100000L);
        DecimalFormat formatter = new DecimalFormat("#,##");
        String firstPart = (num.doubleValue() < 0.0 ? "-" : "") + (numLakhs > 0L ? formatter.format(numLakhs) + "," : "");
        formatter.applyPattern("00,000.00");
        return firstPart + formatter.format(numThousands);
    }

    public static String formatNumber(BigDecimal number, int fractionDigits, boolean useGrouping) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(fractionDigits);
        numberFormat.setMaximumFractionDigits(fractionDigits);
        numberFormat.setGroupingUsed(useGrouping);
        return numberFormat.format(number.doubleValue());
    }

    public static String prefixZero(long value, int paddingSize) {
        return String.format("%0" + paddingSize + "d", value);
    }

    public static enum NumberFormatStyle {
        CRORES,
        MILLIONS;

    }
}

