/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.egov.infra.config.core.LocalizationSettings;

public final class NumberToWordConverter {
    private static final String ZERO = " Zero ";
    private static final String HUNDRED = " Hundred ";
    private static final String THOUSAND = " Thousand ";
    private static final String LAKH = " Lakh ";
    private static final String CRORE = " Crore ";
    private static final String[] WORDS_FOR_MULTIPLES_OF_TENS = new String[]{"Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
    private static final String[] WORDS_FOR_TENS = new String[]{"Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    private static final String[] WORDS_FOR_NUMBER = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};

    private NumberToWordConverter() {
    }

    public static String amountInWordsWithCircumfix(BigDecimal amount) {
        return NumberToWordConverter.numberToWords(amount, true, true);
    }

    public static String numberToWords(BigDecimal number, boolean prefix, boolean suffix) {
        StringBuilder numberInWords = new StringBuilder();
        if (prefix) {
            if (number.intValue() < 2) {
                numberInWords.append(LocalizationSettings.currencyName()).append(" ").append(NumberToWordConverter.convertToWords(number));
            } else {
                numberInWords.append(LocalizationSettings.currencyNamePlural()).append(" ").append(NumberToWordConverter.convertToWords(number));
            }
        } else {
            numberInWords.append(NumberToWordConverter.convertToWords(number));
        }
        if (suffix) {
            numberInWords.append(" Only");
        }
        return numberInWords.toString();
    }

    private static String convertToWords(BigDecimal value) {
        String numberString;
        StringBuilder numberInWord;
        boolean negativeNumber;
        BigDecimal givenNumber = value;
        boolean bl = negativeNumber = givenNumber.signum() == -1;
        if (negativeNumber) {
            givenNumber = givenNumber.abs();
        }
        if ((numberInWord = NumberToWordConverter.convertIntegerPartToWord(Double.parseDouble(numberString = givenNumber.setScale(2, RoundingMode.HALF_UP).toPlainString()))).toString().trim().length() == 0) {
            numberInWord.append(ZERO);
        }
        String result = numberInWord.toString().trim();
        if (negativeNumber) {
            result = "Minus " + result;
        }
        return result;
    }

    private static StringBuilder convertIntegerPartToWord(double number) {
        StringBuilder word = new StringBuilder();
        int quotient = (int)(number / 1.0E7);
        if (quotient > 0) {
            word.append(NumberToWordConverter.convertToWords(new BigDecimal(quotient))).append(CRORE);
        }
        if ((quotient = (int)((number %= 1.0E7) / 100000.0)) > 0) {
            word.append(NumberToWordConverter.numberToWord(quotient)).append(LAKH);
        }
        if ((quotient = (int)((number %= 100000.0) / 1000.0)) > 0) {
            word.append(NumberToWordConverter.numberToWord(quotient)).append(THOUSAND);
        }
        if ((quotient = (int)((number %= 1000.0) / 100.0)) > 0) {
            word.append(NumberToWordConverter.numberToWord(quotient)).append(HUNDRED);
        }
        if ((number %= 100.0) != 0.0) {
            word.append(NumberToWordConverter.numberToWord((int)number)).append(" ");
        }
        NumberToWordConverter.convertFractionalPartToWord(word, number);
        return word;
    }

    private static void convertFractionalPartToWord(StringBuilder word, double number) {
        if (number % 1.0 != 0.0) {
            int fractionalPart;
            String fraction = Double.toString(number).split("\\.")[1];
            if (fraction.length() > 2) {
                fractionalPart = Integer.parseInt(fraction.substring(0, 2));
                if (Integer.parseInt(fraction.substring(2, 3)) > 5) {
                    ++fractionalPart;
                }
            } else {
                fractionalPart = Integer.parseInt(fraction);
            }
            if (fraction.length() == 1) {
                fractionalPart *= 10;
            }
            if (word.toString().trim().length() > 0) {
                word.append("and ");
            }
            word.append(NumberToWordConverter.numberToWord(fractionalPart));
            if (fractionalPart <= 1) {
                word.append(" ").append(LocalizationSettings.currencyUnitName());
            } else {
                word.append(" ").append(LocalizationSettings.currencyUnitNamePlural());
            }
        }
    }

    private static String numberToWord(int number) {
        int remainder;
        int quotient = number / 10;
        StringBuilder word = new StringBuilder();
        if (quotient > 0) {
            if (quotient == 1 && number % 10 > 0) {
                word.append(WORDS_FOR_TENS[number % 10 - 1]);
                return word.toString();
            }
            word.append(WORDS_FOR_MULTIPLES_OF_TENS[quotient - 1]);
        }
        if ((remainder = number % 10) > 0) {
            if (word.length() > 0) {
                word.append(" ");
            }
            word.append(WORDS_FOR_NUMBER[remainder - 1]);
        }
        return word.toString();
    }
}

