/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import org.egov.infra.config.core.LocalizationSettings;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.StringUtils;

@Deprecated
public final class NumberToWord {
    private static final long ZEROS = 0L;
    private static final long UNITS = 1L;
    private static final long TENS = 10L;
    private static final long HUNDREDS = 100L;
    private static final long THOUSANDS = 1000L;
    private static final long TENTHOUSANDS = 10000L;
    private static final long LAKHS = 100000L;
    private static final long TENLAKHS = 1000000L;
    private static final long CRORES = 10000000L;
    private static final long TENCRORES = 100000000L;
    private static final long HUNDREDCRORES = 1000000000L;
    private static final long THOUSANDCRORES = 10000000000L;
    private static final long TENTHOUSANDCRORES = 100000000000L;
    private static final String[] CARDINAL = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety", "Hundred"};
    private static final String THOUSAND_CRORES = " Thousand Crore ";
    private static final String HUNDRED_CRORES = " Hundred Crore ";
    private static final String HUNDRED = " Hundred ";
    private static final String THOUSAND = " Thousand ";
    private static final String LAKH = " Lakh ";
    private static final String CRORE = " Crore ";

    private NumberToWord() {
    }

    public static String amountInWords(Double amount) {
        StringBuffer formattedAmount = new StringBuffer();
        new DecimalFormat("###0.00").format(amount, formattedAmount, new FieldPosition(0));
        return StringUtils.stripExtraSpaces(NumberToWord.convertToWord(formattedAmount.toString()));
    }

    public static String convertToWord(String number) {
        StringBuilder currencyUnitSuffix = new StringBuilder();
        String[] currencyAndUnit = number.split("[.]");
        if (currencyAndUnit.length == 2 && !currencyAndUnit[1].equals("00")) {
            currencyUnitSuffix.append(" and ").append(NumberToWord.paiseInWords(currencyAndUnit[1])).append(" ").append(LocalizationSettings.currencyUnitName()).append(" Only");
        }
        String returnValue = NumberToWord.translateToWord(currencyAndUnit[0]);
        return currencyUnitSuffix.length() < 1 ? LocalizationSettings.currencyName() + " " + returnValue + " Only" : LocalizationSettings.currencyName() + " " + returnValue + currencyUnitSuffix;
    }

    public static String translateToWord(String value) {
        if (!StringUtils.isUnsignedNumber(value)) {
            throw new ApplicationRuntimeException("Provided value is not a valid number");
        }
        StringBuilder numberInWords = new StringBuilder();
        long number = Long.parseLong(value);
        if (number == 0L || value.length() > 12) {
            numberInWords.append(NumberToWord.getWord(number));
        }
        String numericPart = Long.toString(number);
        while (number > 0L && numericPart.length() < 13) {
            Long subNum;
            numericPart = Long.toString(number);
            long place = NumberToWord.getPlace(numericPart);
            if (place == 1000000000L || place == 10000000000L || place == 100000000000L) {
                subNum = Long.parseLong(Character.toString(numericPart.charAt(0)));
                numberInWords.append(NumberToWord.getWord(subNum));
                if (place == 1000000000L) {
                    if ((number -= subNum * 1000000000L) == 0L) {
                        numberInWords.append(HUNDRED_CRORES);
                        continue;
                    }
                    numberInWords.append(HUNDRED);
                    continue;
                }
                if (place == 10000000000L) {
                    if ((number -= subNum * 10000000000L) == 0L) {
                        numberInWords.append(THOUSAND_CRORES);
                        continue;
                    }
                    numberInWords.append(THOUSAND);
                    continue;
                }
                numberInWords.setLength(0);
                subNum = Long.parseLong(Character.toString(numericPart.charAt(0)) + numericPart.charAt(1));
                if (subNum >= 21L && subNum % 10L != 0L && (number -= subNum * 10000000000L) == 0L) {
                    numberInWords.append(NumberToWord.getWord(Long.parseLong(String.valueOf(numericPart.charAt(0))) * 10L)).append(" ").append(NumberToWord.getWord(subNum % 10L)).append(THOUSAND_CRORES);
                    continue;
                }
                if (number == 0L) {
                    numberInWords.append(NumberToWord.getWord(Long.parseLong(String.valueOf(numericPart.charAt(0))) * 10L)).append(THOUSAND_CRORES);
                    continue;
                }
                numberInWords.append(NumberToWord.getWord(Long.parseLong(String.valueOf(numericPart.charAt(0))) * 10L)).append(" ").append(NumberToWord.getWord(subNum % 10L)).append(THOUSAND);
                continue;
            }
            if (place == 10L || place == 10000L || place == 1000000L || place == 100000000L) {
                subNum = Long.parseLong(String.valueOf(numericPart.charAt(0)) + String.valueOf(numericPart.charAt(1)));
                if (subNum >= 21L && subNum % 10L != 0L) {
                    numberInWords.append(NumberToWord.getWord(Long.parseLong(String.valueOf(numericPart.charAt(0))) * 10L)).append(" ").append(NumberToWord.getWord(subNum % 10L));
                } else {
                    numberInWords.append(NumberToWord.getWord(subNum));
                }
                if (place == 10L) {
                    number = 0L;
                    continue;
                }
                if (place == 10000L) {
                    number -= subNum * 1000L;
                    numberInWords.append(THOUSAND);
                    continue;
                }
                if (place == 1000000L) {
                    number -= subNum * 100000L;
                    numberInWords.append(LAKH);
                    continue;
                }
                if (place != 100000000L) continue;
                number -= subNum * 10000000L;
                numberInWords.append(CRORE);
                continue;
            }
            subNum = Long.parseLong(String.valueOf(numericPart.charAt(0)));
            numberInWords.append(NumberToWord.getWord(subNum));
            if (place == 1L) {
                number = 0L;
                continue;
            }
            if (place == 100L) {
                number -= subNum * 100L;
                numberInWords.append(HUNDRED);
                continue;
            }
            if (place == 1000L) {
                number -= subNum * 1000L;
                numberInWords.append(THOUSAND);
                continue;
            }
            if (place == 100000L) {
                number -= subNum * 100000L;
                numberInWords.append(LAKH);
                continue;
            }
            if (place != 10000000L) continue;
            number -= subNum * 10000000L;
            numberInWords.append(CRORE);
        }
        return numberInWords.toString();
    }

    private static long getPlace(String number) {
        switch (number.length()) {
            case 1: {
                return 1L;
            }
            case 2: {
                return 10L;
            }
            case 3: {
                return 100L;
            }
            case 4: {
                return 1000L;
            }
            case 5: {
                return 10000L;
            }
            case 6: {
                return 100000L;
            }
            case 7: {
                return 1000000L;
            }
            case 8: {
                return 10000000L;
            }
            case 9: {
                return 100000000L;
            }
            case 10: {
                return 1000000000L;
            }
            case 11: {
                return 10000000000L;
            }
            case 12: {
                return 100000000000L;
            }
        }
        return 0L;
    }

    private static String getWord(Long number) {
        int value = number.intValue();
        if (value < 0) {
            throw new ApplicationRuntimeException("Number is out of bound");
        }
        switch (value) {
            case 30: {
                return CARDINAL[21];
            }
            case 40: {
                return CARDINAL[22];
            }
            case 50: {
                return CARDINAL[23];
            }
            case 60: {
                return CARDINAL[24];
            }
            case 70: {
                return CARDINAL[25];
            }
            case 80: {
                return CARDINAL[26];
            }
            case 90: {
                return CARDINAL[27];
            }
            case 100: {
                return CARDINAL[28];
            }
        }
        if (value < 21) {
            return CARDINAL[value];
        }
        return "";
    }

    private static String paiseInWords(String paise) {
        StringBuilder returnValue = new StringBuilder();
        Long subNum = paise.length() >= 2 ? Long.valueOf(Long.parseLong(Character.toString(paise.charAt(0)) + paise.charAt(1))) : Long.valueOf(Long.parseLong(Character.toString(paise.charAt(0))));
        if (subNum >= 21L && subNum % 10L != 0L) {
            returnValue.append(NumberToWord.getWord(Long.parseLong(Character.toString(paise.charAt(0))) * 10L)).append(" ").append(NumberToWord.getWord(subNum % 10L));
        } else {
            returnValue.append(NumberToWord.getWord(subNum));
        }
        return returnValue.toString();
    }
}

